/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective.impl.composition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.FlowObjectiveStoreDelegate;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.flowobjective.ObjectiveEvent;
import org.onosproject.net.flowobjective.impl.composition.FlowObjectiveCompositionTree;
import org.onosproject.net.flowobjective.impl.composition.FlowObjectiveCompositionUtil;
import org.onosproject.net.group.GroupService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class FlowObjectiveCompositionManager
implements FlowObjectiveService {
    public static final int INSTALL_RETRY_ATTEMPTS = 5;
    public static final long INSTALL_RETRY_INTERVAL = 1000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveStore flowObjectiveStore;
    private final FlowObjectiveStoreDelegate delegate = new InternalStoreDelegate();
    private final Map<DeviceId, DriverHandler> driverHandlers = Maps.newConcurrentMap();
    private final Map<DeviceId, Pipeliner> pipeliners = Maps.newConcurrentMap();
    private final PipelinerContext context = new InnerPipelineContext();
    private final MastershipListener mastershipListener = new InnerMastershipListener();
    private final DeviceListener deviceListener = new InnerDeviceListener();
    protected ServiceDirectory serviceDirectory = new DefaultServiceDirectory();
    private Map<Integer, Set<PendingNext>> pendingForwards = Maps.newConcurrentMap();
    private ExecutorService executorService;
    private String policy;
    private Map<DeviceId, FlowObjectiveCompositionTree> deviceCompositionTreeMap;

    @Activate
    protected void activate() {
        this.executorService = Executors.newFixedThreadPool(4, Tools.groupedThreads((String)"onos/objective-installer", (String)"%d", (Logger)this.log));
        this.flowObjectiveStore.setDelegate((StoreDelegate)this.delegate);
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.deviceService.getDevices().forEach(device -> this.setupPipelineHandler(device.id()));
        this.deviceCompositionTreeMap = Maps.newConcurrentMap();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.flowObjectiveStore.unsetDelegate((StoreDelegate)this.delegate);
        this.mastershipService.removeListener((EventListener)this.mastershipListener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.executorService.shutdown();
        this.pipeliners.clear();
        this.driverHandlers.clear();
        this.deviceCompositionTreeMap.clear();
        this.log.info("Stopped");
    }

    public void filter(DeviceId deviceId, FilteringObjective filteringObjective) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        List<FilteringObjective> filteringObjectives = this.deviceCompositionTreeMap.get(deviceId).updateFilter(filteringObjective);
        for (FilteringObjective tmp : filteringObjectives) {
            this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)tmp));
        }
    }

    public void forward(DeviceId deviceId, ForwardingObjective forwardingObjective) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        if (this.queueObjective(deviceId, forwardingObjective)) {
            return;
        }
        List<ForwardingObjective> forwardingObjectives = this.deviceCompositionTreeMap.get(deviceId).updateForward(forwardingObjective);
        for (ForwardingObjective tmp : forwardingObjectives) {
            this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)tmp));
        }
    }

    public void next(DeviceId deviceId, NextObjective nextObjective) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        List<NextObjective> nextObjectives = this.deviceCompositionTreeMap.get(deviceId).updateNext(nextObjective);
        for (NextObjective tmp : nextObjectives) {
            this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)tmp));
        }
    }

    public int allocateNextId() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        return this.flowObjectiveStore.allocateNextId();
    }

    private boolean queueObjective(DeviceId deviceId, ForwardingObjective fwd) {
        if (fwd.nextId() != null && this.flowObjectiveStore.getNextGroup(fwd.nextId()) == null) {
            this.log.trace("Queuing forwarding objective for nextId {}", (Object)fwd.nextId());
            if (this.pendingForwards.putIfAbsent(fwd.nextId(), Sets.newHashSet((Object[])new PendingNext[]{new PendingNext(deviceId, fwd)})) != null) {
                Set<PendingNext> pending = this.pendingForwards.get(fwd.nextId());
                pending.add(new PendingNext(deviceId, fwd));
            }
            return true;
        }
        return false;
    }

    public void initPolicy(String policy) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        this.policy = policy;
        this.deviceService.getDevices().forEach(device -> this.deviceCompositionTreeMap.put(device.id(), FlowObjectiveCompositionUtil.parsePolicyString(policy)));
        this.log.info("Initialize policy {}", (Object)policy);
    }

    private Pipeliner getDevicePipeliner(DeviceId deviceId) {
        return this.pipeliners.get(deviceId);
    }

    private void setupPipelineHandler(DeviceId deviceId) {
        DriverHandler handler = this.driverHandlers.get(deviceId);
        if (handler == null) {
            try {
                handler = this.driverService.createHandler(deviceId, new String[0]);
                if (!handler.driver().hasBehaviour(Pipeliner.class)) {
                    this.log.warn("Pipeline behaviour not supported for device {}", (Object)deviceId);
                    return;
                }
            }
            catch (ItemNotFoundException e) {
                this.log.warn("No applicable driver for device {}", (Object)deviceId);
                return;
            }
            this.driverHandlers.put(deviceId, handler);
        }
        this.log.info("Driver {} bound to device {} ... initializing driver", (Object)handler.driver().name(), (Object)deviceId);
        Pipeliner pipeliner = (Pipeliner)handler.behaviour(Pipeliner.class);
        pipeliner.init(deviceId, this.context);
        this.pipeliners.putIfAbsent(deviceId, pipeliner);
    }

    public static String forwardingObjectiveToString(ForwardingObjective forwardingObjective) {
        String str = forwardingObjective.priority() + " ";
        str = str + "selector( ";
        for (Criterion criterion : forwardingObjective.selector().criteria()) {
            str = str + criterion + " ";
        }
        str = str + ") treatment( ";
        for (Instruction instruction : forwardingObjective.treatment().allInstructions()) {
            str = str + instruction + " ";
        }
        str = str + ")";
        return str;
    }

    public List<String> getNextMappings() {
        return ImmutableList.of();
    }

    public List<String> getPendingFlowObjectives() {
        return ImmutableList.of();
    }

    public List<String> getPendingNexts() {
        return ImmutableList.of();
    }

    private class PendingNext {
        private final DeviceId deviceId;
        private final ForwardingObjective fwd;

        public PendingNext(DeviceId deviceId, ForwardingObjective fwd) {
            this.deviceId = deviceId;
            this.fwd = fwd;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public ForwardingObjective forwardingObjective() {
            return this.fwd;
        }
    }

    private class InternalStoreDelegate
    implements FlowObjectiveStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(ObjectiveEvent event) {
            FlowObjectiveCompositionManager.this.log.debug("Received notification of obj event {}", (Object)event);
            Set pending = (Set)FlowObjectiveCompositionManager.this.pendingForwards.remove(event.subject());
            if (pending == null) {
                FlowObjectiveCompositionManager.this.log.debug("Nothing pending for this obj event");
                return;
            }
            FlowObjectiveCompositionManager.this.log.debug("Processing pending forwarding objectives {}", (Object)pending.size());
            pending.forEach(p -> FlowObjectiveCompositionManager.this.getDevicePipeliner(p.deviceId()).forward(p.forwardingObjective()));
        }
    }

    private class InnerPipelineContext
    implements PipelinerContext {
        private InnerPipelineContext() {
        }

        public ServiceDirectory directory() {
            return FlowObjectiveCompositionManager.this.serviceDirectory;
        }

        public FlowObjectiveStore store() {
            return FlowObjectiveCompositionManager.this.flowObjectiveStore;
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    FlowObjectiveCompositionManager.this.log.debug("Device either added or availability changed {}", (Object)((Device)event.subject()).id());
                    if (!FlowObjectiveCompositionManager.this.deviceService.isAvailable(((Device)event.subject()).id())) break;
                    FlowObjectiveCompositionManager.this.log.debug("Device is now available {}", (Object)((Device)event.subject()).id());
                    FlowObjectiveCompositionManager.this.setupPipelineHandler(((Device)event.subject()).id());
                    break;
                }
                case DEVICE_UPDATED: {
                    break;
                }
                case DEVICE_REMOVED: {
                    break;
                }
                case DEVICE_SUSPENDED: {
                    break;
                }
                case PORT_ADDED: {
                    break;
                }
                case PORT_UPDATED: {
                    break;
                }
                case PORT_REMOVED: {
                    break;
                }
            }
        }
    }

    private class InnerMastershipListener
    implements MastershipListener {
        private InnerMastershipListener() {
        }

        public void event(MastershipEvent event) {
            switch ((MastershipEvent.Type)event.type()) {
                case MASTER_CHANGED: {
                    FlowObjectiveCompositionManager.this.log.debug("mastership changed on device {}", event.subject());
                    if (!FlowObjectiveCompositionManager.this.deviceService.isAvailable((DeviceId)event.subject())) break;
                    FlowObjectiveCompositionManager.this.setupPipelineHandler((DeviceId)event.subject());
                    break;
                }
                case BACKUPS_CHANGED: {
                    break;
                }
            }
        }
    }

    private class ObjectiveInstaller
    implements Runnable {
        private final DeviceId deviceId;
        private final Objective objective;
        private final int numAttempts;

        public ObjectiveInstaller(DeviceId deviceId, Objective objective) {
            this(deviceId, objective, 1);
        }

        public ObjectiveInstaller(DeviceId deviceId, Objective objective, int attemps) {
            this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
            this.objective = (Objective)Preconditions.checkNotNull((Object)objective);
            this.numAttempts = (Integer)Preconditions.checkNotNull((Object)attemps);
        }

        @Override
        public void run() {
            try {
                Pipeliner pipeliner = FlowObjectiveCompositionManager.this.getDevicePipeliner(this.deviceId);
                if (pipeliner != null) {
                    if (this.objective instanceof NextObjective) {
                        pipeliner.next((NextObjective)this.objective);
                    } else if (this.objective instanceof ForwardingObjective) {
                        pipeliner.forward((ForwardingObjective)this.objective);
                    } else {
                        pipeliner.filter((FilteringObjective)this.objective);
                    }
                } else if (this.numAttempts < 5) {
                    Thread.sleep(1000L);
                    FlowObjectiveCompositionManager.this.executorService.execute(new ObjectiveInstaller(this.deviceId, this.objective, this.numAttempts + 1));
                } else {
                    this.objective.context().ifPresent(c -> c.onError(this.objective, ObjectiveError.NOPIPELINER));
                }
            }
            catch (Exception e) {
                FlowObjectiveCompositionManager.this.log.warn("Exception while installing flow objective", (Throwable)e);
            }
        }
    }

    public static enum PolicyOperator {
        Parallel,
        Sequential,
        Override,
        Application;

    }
}

