/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.FlowObjectiveStoreDelegate;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.flowobjective.ObjectiveEvent;
import org.onosproject.net.group.GroupService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class FlowObjectiveManager
implements FlowObjectiveService {
    public static final int INSTALL_RETRY_ATTEMPTS = 5;
    public static final long INSTALL_RETRY_INTERVAL = 1000L;
    private static final String WORKER_PATTERN = "objective-installer-%d";
    private static final String GROUP_THREAD_NAME = "onos/objective-installer";
    private static final String NUM_THREAD = "numThreads";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_NUM_THREADS = 4;
    @Property(name="numThreads", intValue={4}, label="Number of worker threads")
    private int numThreads = 4;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveStore flowObjectiveStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private final FlowObjectiveStoreDelegate delegate = new InternalStoreDelegate();
    private final Map<DeviceId, DriverHandler> driverHandlers = Maps.newConcurrentMap();
    private final Map<DeviceId, Pipeliner> pipeliners = Maps.newConcurrentMap();
    private final PipelinerContext context = new InnerPipelineContext();
    private final DeviceListener deviceListener = new InnerDeviceListener();
    protected ServiceDirectory serviceDirectory = new DefaultServiceDirectory();
    private final Map<Integer, Set<PendingFlowObjective>> pendingForwards = Maps.newConcurrentMap();
    private final Map<Integer, Set<PendingFlowObjective>> pendingNexts = Maps.newConcurrentMap();
    private Map<Integer, DeviceId> nextToDevice = Maps.newConcurrentMap();
    private ExecutorService executorService;
    private long start = 0L;
    private long totals = 0L;
    private long count = 0L;
    private long cTime;
    private long dTime;
    private long eTime;
    private long hTime;
    private long hbTime;
    private static final long LIMIT = 500L;

    @Activate
    protected void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.executorService = Executors.newFixedThreadPool(this.numThreads, Tools.groupedThreads((String)GROUP_THREAD_NAME, (String)WORKER_PATTERN, (Logger)this.log));
        this.flowObjectiveStore.setDelegate((StoreDelegate)this.delegate);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.flowObjectiveStore.unsetDelegate((StoreDelegate)this.delegate);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.executorService.shutdown();
        this.pipeliners.clear();
        this.driverHandlers.clear();
        this.nextToDevice.clear();
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        int newNumThreads;
        String propertyValue = Tools.get((Dictionary)context.getProperties(), (String)NUM_THREAD);
        int n = newNumThreads = Strings.isNullOrEmpty((String)propertyValue) ? this.numThreads : Integer.parseInt(propertyValue);
        if (newNumThreads != this.numThreads && newNumThreads > 0) {
            this.numThreads = newNumThreads;
            ExecutorService oldWorkerExecutor = this.executorService;
            this.executorService = Executors.newFixedThreadPool(this.numThreads, Tools.groupedThreads((String)GROUP_THREAD_NAME, (String)WORKER_PATTERN, (Logger)this.log));
            if (oldWorkerExecutor != null) {
                oldWorkerExecutor.shutdown();
            }
            this.log.info("Reconfigured number of worker threads to {}", (Object)this.numThreads);
        }
    }

    public void filter(DeviceId deviceId, FilteringObjective filteringObjective) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)filteringObjective));
    }

    public void forward(DeviceId deviceId, ForwardingObjective forwardingObjective) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        if (forwardingObjective.nextId() == null || forwardingObjective.op() == Objective.Operation.REMOVE || this.flowObjectiveStore.getNextGroup(forwardingObjective.nextId()) != null || !this.queueFwdObjective(deviceId, forwardingObjective)) {
            this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)forwardingObjective));
        }
    }

    public void next(DeviceId deviceId, NextObjective nextObjective) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        if (nextObjective.op() == Objective.Operation.ADD || this.flowObjectiveStore.getNextGroup(Integer.valueOf(nextObjective.id())) != null || !this.queueNextObjective(deviceId, nextObjective)) {
            this.executorService.execute(new ObjectiveInstaller(deviceId, (Objective)nextObjective));
        }
    }

    public int allocateNextId() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        return this.flowObjectiveStore.allocateNextId();
    }

    public void initPolicy(String policy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueFwdObjective(DeviceId deviceId, ForwardingObjective fwd) {
        boolean queued = false;
        Map<Integer, Set<PendingFlowObjective>> map = this.pendingForwards;
        synchronized (map) {
            if (this.flowObjectiveStore.getNextGroup(fwd.nextId()) == null) {
                this.pendingForwards.compute(fwd.nextId(), (id, pending) -> {
                    PendingFlowObjective pendfo = new PendingFlowObjective(deviceId, (Objective)fwd);
                    if (pending == null) {
                        return Sets.newHashSet((Object[])new PendingFlowObjective[]{pendfo});
                    }
                    pending.add(pendfo);
                    return pending;
                });
                queued = true;
            }
        }
        if (queued) {
            this.log.debug("Queued forwarding objective {} for nextId {} meant for device {}", new Object[]{fwd.id(), fwd.nextId(), deviceId});
        }
        return queued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queueNextObjective(DeviceId deviceId, NextObjective next) {
        boolean queued = false;
        Map<Integer, Set<PendingFlowObjective>> map = this.pendingNexts;
        synchronized (map) {
            if (this.flowObjectiveStore.getNextGroup(Integer.valueOf(next.id())) == null) {
                this.pendingNexts.compute(next.id(), (id, pending) -> {
                    PendingFlowObjective pendfo = new PendingFlowObjective(deviceId, (Objective)next);
                    if (pending == null) {
                        return Sets.newHashSet((Object[])new PendingFlowObjective[]{pendfo});
                    }
                    pending.add(pendfo);
                    return pending;
                });
                queued = true;
            }
        }
        if (queued) {
            this.log.debug("Queued next objective {} with operation {} meant for device {}", new Object[]{next.id(), next.op(), deviceId});
        }
        return queued;
    }

    private Pipeliner getDevicePipeliner(DeviceId deviceId) {
        return this.pipeliners.computeIfAbsent(deviceId, this::initPipelineHandler);
    }

    private Pipeliner getAndInitDevicePipeliner(DeviceId deviceId) {
        return this.pipeliners.compute(deviceId, (deviceIdValue, pipelinerValue) -> {
            if (pipelinerValue != null) {
                pipelinerValue.init(deviceId, this.context);
                return pipelinerValue;
            }
            return this.initPipelineHandler(deviceId);
        });
    }

    private Pipeliner initPipelineHandler(DeviceId deviceId) {
        this.start = this.now();
        DriverHandler handler = this.driverHandlers.get(deviceId);
        this.cTime = this.now();
        if (handler == null) {
            try {
                handler = this.driverService.createHandler(deviceId, new String[0]);
                this.dTime = this.now();
                if (!handler.driver().hasBehaviour(Pipeliner.class)) {
                    this.log.debug("Pipeline behaviour not supported for device {}", (Object)deviceId);
                    return null;
                }
            }
            catch (ItemNotFoundException e) {
                this.log.warn("No applicable driver for device {}", (Object)deviceId);
                return null;
            }
            this.driverHandlers.put(deviceId, handler);
            this.eTime = this.now();
        }
        this.log.info("Driver {} bound to device {} ... initializing driver", (Object)handler.driver().name(), (Object)deviceId);
        this.hTime = this.now();
        Pipeliner pipeliner = (Pipeliner)handler.behaviour(Pipeliner.class);
        this.hbTime = this.now();
        pipeliner.init(deviceId, this.context);
        this.stopWatch();
        return pipeliner;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private void stopWatch() {
        long duration = System.currentTimeMillis() - this.start;
        this.totals += duration;
        ++this.count;
        if (duration > 500L) {
            this.log.info("Pipeline setup took {} ms; avg {} ms; cTime={}, dTime={}, eTime={}, hTime={}, hbTime={}", new Object[]{duration, this.totals / this.count, this.diff(this.cTime), this.diff(this.dTime), this.diff(this.eTime), this.diff(this.hTime), this.diff(this.hbTime)});
        }
    }

    private long diff(long bTime) {
        long diff = bTime - this.start;
        return diff < 0L ? 0L : diff;
    }

    public List<String> getNextMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        Map allnexts = this.flowObjectiveStore.getAllGroups();
        for (Map.Entry e : allnexts.entrySet()) {
            Pipeliner pipeliner;
            List nextMappings;
            DeviceId deviceId = this.nextToDevice.get(e.getKey());
            mappings.add("NextId " + e.getKey() + ": " + (deviceId != null ? deviceId : "nextId not in this onos instance"));
            if (deviceId == null || (nextMappings = (pipeliner = this.getDevicePipeliner(deviceId)).getNextMappings((NextGroup)e.getValue())) == null) continue;
            mappings.addAll(nextMappings);
        }
        return mappings;
    }

    public List<String> getPendingFlowObjectives() {
        StringBuilder pend;
        ArrayList<String> pendingFlowObjectives = new ArrayList<String>();
        for (Integer nextId : this.pendingForwards.keySet()) {
            Set<PendingFlowObjective> pfwd = this.pendingForwards.get(nextId);
            pend = new StringBuilder();
            pend.append("NextId: ").append(nextId);
            for (PendingFlowObjective pf : pfwd) {
                pend.append("\n    FwdId: ").append(String.format("%11s", pf.flowObjective().id())).append(", DeviceId: ").append(pf.deviceId()).append(", Selector: ").append(((ForwardingObjective)pf.flowObjective()).selector().criteria());
            }
            pendingFlowObjectives.add(pend.toString());
        }
        for (Integer nextId : this.pendingNexts.keySet()) {
            Set<PendingFlowObjective> pnext = this.pendingNexts.get(nextId);
            pend = new StringBuilder();
            pend.append("NextId: ").append(nextId);
            for (PendingFlowObjective pn : pnext) {
                pend.append("\n    NextOp: ").append(pn.flowObjective().op()).append(", DeviceId: ").append(pn.deviceId()).append(", Treatments: ").append(((NextObjective)pn.flowObjective()).next());
            }
            pendingFlowObjectives.add(pend.toString());
        }
        return pendingFlowObjectives;
    }

    public List<String> getPendingNexts() {
        return this.getPendingFlowObjectives();
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindFlowObjectiveStore(FlowObjectiveStore flowObjectiveStore) {
        this.flowObjectiveStore = flowObjectiveStore;
    }

    protected void unbindFlowObjectiveStore(FlowObjectiveStore flowObjectiveStore) {
        if (this.flowObjectiveStore == flowObjectiveStore) {
            this.flowObjectiveStore = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class PendingFlowObjective {
        private final DeviceId deviceId;
        private final Objective flowObj;

        public PendingFlowObjective(DeviceId deviceId, Objective flowObj) {
            this.deviceId = deviceId;
            this.flowObj = flowObj;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        public Objective flowObjective() {
            return this.flowObj;
        }

        public int hashCode() {
            return Objects.hash(this.deviceId, this.flowObj);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PendingFlowObjective)) {
                return false;
            }
            PendingFlowObjective other = (PendingFlowObjective)obj;
            return this.deviceId.equals((Object)other.deviceId) && this.flowObj.equals(other.flowObj);
        }
    }

    private class InternalStoreDelegate
    implements FlowObjectiveStoreDelegate {
        private InternalStoreDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(ObjectiveEvent event) {
            if (event.type() == ObjectiveEvent.Type.ADD) {
                Set pending;
                FlowObjectiveManager.this.log.debug("Received notification of obj event {}", (Object)event);
                Map map = FlowObjectiveManager.this.pendingForwards;
                synchronized (map) {
                    pending = (Set)FlowObjectiveManager.this.pendingForwards.remove(event.subject());
                }
                if (pending == null) {
                    FlowObjectiveManager.this.log.debug("No forwarding objectives pending for this obj event {}", (Object)event);
                } else {
                    FlowObjectiveManager.this.log.debug("Processing {} pending forwarding objectives for nextId {}", (Object)pending.size(), event.subject());
                    pending.forEach(p -> FlowObjectiveManager.this.getDevicePipeliner(p.deviceId()).forward((ForwardingObjective)p.flowObjective()));
                }
                map = FlowObjectiveManager.this.pendingNexts;
                synchronized (map) {
                    pending = (Set)FlowObjectiveManager.this.pendingNexts.remove(event.subject());
                }
                if (pending == null) {
                    FlowObjectiveManager.this.log.debug("No next objectives pending for this obj event {}", (Object)event);
                } else {
                    FlowObjectiveManager.this.log.debug("Processing {} pending next objectives for nextId {}", (Object)pending.size(), event.subject());
                    pending.forEach(p -> FlowObjectiveManager.this.getDevicePipeliner(p.deviceId()).next((NextObjective)p.flowObjective()));
                }
            }
        }
    }

    private class InnerPipelineContext
    implements PipelinerContext {
        private InnerPipelineContext() {
        }

        public ServiceDirectory directory() {
            return FlowObjectiveManager.this.serviceDirectory;
        }

        public FlowObjectiveStore store() {
            return FlowObjectiveManager.this.flowObjectiveStore;
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    FlowObjectiveManager.this.log.debug("Device either added or availability changed {}", (Object)((Device)event.subject()).id());
                    if (FlowObjectiveManager.this.deviceService.isAvailable(((Device)event.subject()).id())) {
                        FlowObjectiveManager.this.log.debug("Device is now available {}", (Object)((Device)event.subject()).id());
                        FlowObjectiveManager.this.getAndInitDevicePipeliner(((Device)event.subject()).id());
                        break;
                    }
                    FlowObjectiveManager.this.log.debug("Device is no longer available {}", (Object)((Device)event.subject()).id());
                    break;
                }
                case DEVICE_UPDATED: {
                    break;
                }
                case DEVICE_REMOVED: {
                    FlowObjectiveManager.this.driverHandlers.remove(((Device)event.subject()).id());
                    FlowObjectiveManager.this.pipeliners.remove(((Device)event.subject()).id());
                    break;
                }
                case DEVICE_SUSPENDED: {
                    break;
                }
                case PORT_ADDED: {
                    break;
                }
                case PORT_UPDATED: {
                    break;
                }
                case PORT_REMOVED: {
                    break;
                }
            }
        }
    }

    private class ObjectiveInstaller
    implements Runnable {
        private final DeviceId deviceId;
        private final Objective objective;
        private final int numAttempts;

        public ObjectiveInstaller(DeviceId deviceId, Objective objective) {
            this(deviceId, objective, 1);
        }

        public ObjectiveInstaller(DeviceId deviceId, Objective objective, int attemps) {
            this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
            this.objective = (Objective)Preconditions.checkNotNull((Object)objective);
            this.numAttempts = (Integer)Preconditions.checkNotNull((Object)attemps);
        }

        @Override
        public void run() {
            try {
                Pipeliner pipeliner = FlowObjectiveManager.this.getDevicePipeliner(this.deviceId);
                if (pipeliner != null) {
                    if (this.objective instanceof NextObjective) {
                        FlowObjectiveManager.this.nextToDevice.put(this.objective.id(), this.deviceId);
                        pipeliner.next((NextObjective)this.objective);
                    } else if (this.objective instanceof ForwardingObjective) {
                        pipeliner.forward((ForwardingObjective)this.objective);
                    } else {
                        pipeliner.filter((FilteringObjective)this.objective);
                    }
                } else if (this.numAttempts < 5) {
                    Thread.sleep(1000L);
                    FlowObjectiveManager.this.executorService.execute(new ObjectiveInstaller(this.deviceId, this.objective, this.numAttempts + 1));
                } else {
                    this.objective.context().ifPresent(c -> c.onError(this.objective, ObjectiveError.NOPIPELINER));
                }
            }
            catch (Exception e) {
                FlowObjectiveManager.this.log.warn("Exception while installing flow objective", (Throwable)e);
            }
        }
    }
}

