/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleOperation;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleProgrammable;
import org.onosproject.net.flow.FlowRuleProvider;
import org.onosproject.net.flow.FlowRuleProviderRegistry;
import org.onosproject.net.flow.FlowRuleProviderService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.FlowRuleStore;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.flow.impl.FlowRuleDriverProvider;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class FlowRuleManager
extends AbstractListenerProviderRegistry<FlowRuleEvent, FlowRuleListener, FlowRuleProvider, FlowRuleProviderService>
implements FlowRuleService,
FlowRuleProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String FLOW_RULE_NULL = "FlowRule cannot be null";
    private static final boolean ALLOW_EXTRANEOUS_RULES = false;
    @Property(name="allowExtraneousRules", boolValue={false}, label="Allow flow rules in switch not installed by ONOS")
    private boolean allowExtraneousRules = false;
    @Property(name="purgeOnDisconnection", boolValue={false}, label="Purge entries associated with a device when the device goes offline")
    private boolean purgeOnDisconnection = false;
    private static final int DEFAULT_POLL_FREQUENCY = 30;
    @Property(name="fallbackFlowPollFrequency", intValue={30}, label="Frequency (in seconds) for polling flow statistics via fallback provider")
    private int fallbackFlowPollFrequency = 30;
    private final FlowRuleStoreDelegate delegate = new InternalStoreDelegate();
    private final DeviceListener deviceListener = new InternalDeviceListener();
    private final FlowRuleDriverProvider driverProvider = new FlowRuleDriverProvider();
    protected ExecutorService deviceInstallers = Executors.newFixedThreadPool(32, Tools.groupedThreads((String)"onos/flowservice", (String)"device-installer-%d", (Logger)this.log));
    protected ExecutorService operationsService = Executors.newFixedThreadPool(32, Tools.groupedThreads((String)"onos/flowservice", (String)"operations-%d", (Logger)this.log));
    private IdGenerator idGenerator;
    private final Map<Long, FlowOperationsProcessor> pendingFlowOperations = new ConcurrentHashMap<Long, FlowOperationsProcessor>();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;

    @Activate
    public void activate(ComponentContext context) {
        this.modified(context);
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(FlowRuleEvent.class, (EventSink)this.listenerRegistry);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.idGenerator = this.coreService.getIdGenerator("flow-ops-ids");
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.deviceInstallers.shutdownNow();
        this.operationsService.shutdownNow();
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(FlowRuleEvent.class);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        if (context != null) {
            this.readComponentConfiguration(context);
        }
        this.driverProvider.init(new InternalFlowRuleProviderService(this.driverProvider), this.deviceService, this.mastershipService, this.fallbackFlowPollFrequency);
    }

    protected FlowRuleProvider defaultProvider() {
        return this.driverProvider;
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"allowExtraneousRules");
        if (flag == null) {
            this.log.info("AllowExtraneousRules is not configured, using current value of {}", (Object)this.allowExtraneousRules);
        } else {
            this.allowExtraneousRules = flag;
            this.log.info("Configured. AllowExtraneousRules is {}", (Object)(this.allowExtraneousRules ? "enabled" : "disabled"));
        }
        flag = Tools.isPropertyEnabled((Dictionary)properties, (String)"purgeOnDisconnection");
        if (flag == null) {
            this.log.info("PurgeOnDisconnection is not configured, using current value of {}", (Object)this.purgeOnDisconnection);
        } else {
            this.purgeOnDisconnection = flag;
            this.log.info("Configured. PurgeOnDisconnection is {}", (Object)(this.purgeOnDisconnection ? "enabled" : "disabled"));
        }
        String s = Tools.get((Dictionary)properties, (String)"fallbackFlowPollFrequency");
        try {
            this.fallbackFlowPollFrequency = Strings.isNullOrEmpty((String)s) ? 30 : Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.fallbackFlowPollFrequency = 30;
        }
    }

    public int getFlowRuleCount() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_READ);
        return this.store.getFlowRuleCount();
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_READ);
        return this.store.getFlowEntries(deviceId);
    }

    public void applyFlowRules(FlowRule ... flowRules) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        for (FlowRule flowRule : flowRules) {
            builder.add(flowRule);
        }
        this.apply(builder.build());
    }

    public void purgeFlowRules(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        this.store.purgeFlowRule(deviceId);
    }

    public void removeFlowRules(FlowRule ... flowRules) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        for (FlowRule flowRule : flowRules) {
            builder.remove(flowRule);
        }
        this.apply(builder.build());
    }

    public void removeFlowRulesById(ApplicationId id) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        this.removeFlowRules((FlowRule[])Iterables.toArray(this.getFlowRulesById(id), FlowRule.class));
    }

    @Deprecated
    public Iterable<FlowRule> getFlowRulesById(ApplicationId id) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_READ);
        HashSet flowEntries = Sets.newHashSet();
        for (Device d : this.deviceService.getDevices()) {
            for (FlowEntry flowEntry : this.store.getFlowEntries(d.id())) {
                if (flowEntry.appId() != id.id()) continue;
                flowEntries.add(flowEntry);
            }
        }
        return flowEntries;
    }

    public Iterable<FlowEntry> getFlowEntriesById(ApplicationId id) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_READ);
        HashSet flowEntries = Sets.newHashSet();
        for (Device d : this.deviceService.getDevices()) {
            for (FlowEntry flowEntry : this.store.getFlowEntries(d.id())) {
                if (flowEntry.appId() != id.id()) continue;
                flowEntries.add(flowEntry);
            }
        }
        return flowEntries;
    }

    public Iterable<FlowRule> getFlowRulesByGroupId(ApplicationId appId, short groupId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_READ);
        HashSet matches = Sets.newHashSet();
        long toLookUp = (long)appId.id() << 16 | (long)groupId;
        for (Device d : this.deviceService.getDevices()) {
            for (FlowEntry flowEntry : this.store.getFlowEntries(d.id())) {
                if (flowEntry.id().value() >>> 32 != toLookUp) continue;
                matches.add(flowEntry);
            }
        }
        return matches;
    }

    public void apply(FlowRuleOperations ops) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_WRITE);
        this.operationsService.execute(new FlowOperationsProcessor(ops));
    }

    protected FlowRuleProviderService createProviderService(FlowRuleProvider provider) {
        return new InternalFlowRuleProviderService(provider);
    }

    protected synchronized FlowRuleProvider getProvider(ProviderId pid) {
        this.log.warn("should not be calling getProvider(ProviderId)");
        return (FlowRuleProvider)super.getProvider(pid);
    }

    protected synchronized FlowRuleProvider getProvider(DeviceId deviceId) {
        return Optional.ofNullable(this.deviceService.getDevice(deviceId)).filter(dev -> dev.is(FlowRuleProgrammable.class)).map(x -> this.driverProvider).orElseGet(() -> (FlowRuleProvider)super.getProvider(deviceId));
    }

    private static FlowRuleBatchEntry.FlowRuleOperation mapOperationType(FlowRuleOperation.Type input) {
        switch (input) {
            case ADD: {
                return FlowRuleBatchEntry.FlowRuleOperation.ADD;
            }
            case MODIFY: {
                return FlowRuleBatchEntry.FlowRuleOperation.MODIFY;
            }
            case REMOVE: {
                return FlowRuleBatchEntry.FlowRuleOperation.REMOVE;
            }
        }
        throw new UnsupportedOperationException("Unknown flow rule type " + input);
    }

    public Iterable<TableStatisticsEntry> getFlowTableStatistics(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.FLOWRULE_READ);
        return this.store.getTableStatistics(deviceId);
    }

    protected void bindStore(FlowRuleStore flowRuleStore) {
        this.store = flowRuleStore;
    }

    protected void unbindStore(FlowRuleStore flowRuleStore) {
        if (this.store == flowRuleStore) {
            this.store = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_REMOVED: 
                case DEVICE_AVAILABILITY_CHANGED: {
                    DeviceId deviceId = ((Device)event.subject()).id();
                    if (FlowRuleManager.this.deviceService.isAvailable(deviceId) || !FlowRuleManager.this.purgeOnDisconnection) break;
                    FlowRuleManager.this.store.purgeFlowRule(deviceId);
                    break;
                }
            }
        }
    }

    private class FlowOperationsProcessor
    implements Runnable {
        private final FlowRuleOperations fops;
        private final List<Set<FlowRuleOperation>> stages;
        private final Set<DeviceId> pendingDevices = new HashSet<DeviceId>();
        private boolean hasFailed = false;

        FlowOperationsProcessor(FlowRuleOperations ops) {
            this.stages = Lists.newArrayList((Iterable)ops.stages());
            this.fops = ops;
        }

        @Override
        public synchronized void run() {
            if (!this.stages.isEmpty()) {
                this.process(this.stages.remove(0));
            } else if (!this.hasFailed) {
                this.fops.callback().onSuccess(this.fops);
            }
        }

        private void process(Set<FlowRuleOperation> ops) {
            ArrayListMultimap perDeviceBatches = ArrayListMultimap.create();
            for (FlowRuleOperation op : ops) {
                perDeviceBatches.put((Object)op.rule().deviceId(), (Object)new FlowRuleBatchEntry(FlowRuleManager.mapOperationType(op.type()), op.rule()));
            }
            this.pendingDevices.addAll(perDeviceBatches.keySet());
            for (DeviceId deviceId : perDeviceBatches.keySet()) {
                long id = FlowRuleManager.this.idGenerator.getNewId();
                FlowRuleBatchOperation b = new FlowRuleBatchOperation(perDeviceBatches.get((Object)deviceId), deviceId, id);
                FlowRuleManager.this.pendingFlowOperations.put(id, this);
                FlowRuleManager.this.deviceInstallers.execute(() -> FlowRuleManager.this.store.storeBatch(b));
            }
        }

        synchronized void satisfy(DeviceId devId) {
            this.pendingDevices.remove(devId);
            if (this.pendingDevices.isEmpty()) {
                FlowRuleManager.this.operationsService.execute(this);
            }
        }

        synchronized void fail(DeviceId devId, Set<? extends FlowRule> failures) {
            this.hasFailed = true;
            this.pendingDevices.remove(devId);
            if (this.pendingDevices.isEmpty()) {
                FlowRuleManager.this.operationsService.execute(this);
            }
            FlowRuleOperations.Builder failedOpsBuilder = FlowRuleOperations.builder();
            failures.forEach(arg_0 -> ((FlowRuleOperations.Builder)failedOpsBuilder).add(arg_0));
            this.fops.callback().onError(failedOpsBuilder.build());
        }
    }

    private class InternalStoreDelegate
    implements FlowRuleStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(FlowRuleBatchEvent event) {
            FlowRuleBatchRequest request = (FlowRuleBatchRequest)event.subject();
            switch ((FlowRuleBatchEvent.Type)event.type()) {
                case BATCH_OPERATION_REQUESTED: {
                    request.ops().forEach(op -> {
                        switch ((FlowRuleBatchEntry.FlowRuleOperation)op.operator()) {
                            case ADD: {
                                FlowRuleManager.this.post((Event)new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADD_REQUESTED, (FlowRule)op.target()));
                                break;
                            }
                            case REMOVE: {
                                FlowRuleManager.this.post((Event)new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVE_REQUESTED, (FlowRule)op.target()));
                                break;
                            }
                            case MODIFY: {
                                break;
                            }
                            default: {
                                FlowRuleManager.this.log.warn("Unknown flow operation operator: {}", (Object)op.operator());
                            }
                        }
                    });
                    DeviceId deviceId = event.deviceId();
                    FlowRuleBatchOperation batchOperation = request.asBatchOperation(deviceId);
                    FlowRuleProvider flowRuleProvider = FlowRuleManager.this.getProvider(deviceId);
                    if (flowRuleProvider == null) break;
                    flowRuleProvider.executeBatch(batchOperation);
                    break;
                }
                case BATCH_OPERATION_COMPLETED: {
                    FlowOperationsProcessor fops = (FlowOperationsProcessor)FlowRuleManager.this.pendingFlowOperations.remove(((FlowRuleBatchRequest)event.subject()).batchId());
                    if (event.result().isSuccess()) {
                        if (fops == null) break;
                        fops.satisfy(event.deviceId());
                        break;
                    }
                    fops.fail(event.deviceId(), event.result().failedItems());
                    break;
                }
            }
        }
    }

    private class InternalFlowRuleProviderService
    extends AbstractProviderService<FlowRuleProvider>
    implements FlowRuleProviderService {
        final Map<FlowEntry, Long> firstSeen;
        final Map<FlowEntry, Long> lastSeen;

        protected InternalFlowRuleProviderService(FlowRuleProvider provider) {
            super((Provider)provider);
            this.firstSeen = Maps.newConcurrentMap();
            this.lastSeen = Maps.newConcurrentMap();
        }

        public void flowRemoved(FlowEntry flowEntry) {
            Preconditions.checkNotNull((Object)flowEntry, (Object)FlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            this.lastSeen.remove(flowEntry);
            this.firstSeen.remove(flowEntry);
            FlowEntry stored = FlowRuleManager.this.store.getFlowEntry((FlowRule)flowEntry);
            if (stored == null) {
                FlowRuleManager.this.log.debug("Rule already evicted from store: {}", (Object)flowEntry);
                return;
            }
            if (flowEntry.reason() == FlowRule.FlowRemoveReason.HARD_TIMEOUT) {
                ((DefaultFlowEntry)stored).setState(FlowEntry.FlowEntryState.REMOVED);
            }
            FlowRuleProvider frp = FlowRuleManager.this.getProvider(flowEntry.deviceId());
            FlowRuleEvent event = null;
            switch (stored.state()) {
                case ADDED: 
                case PENDING_ADD: {
                    frp.applyFlowRule(new FlowRule[]{stored});
                    break;
                }
                case PENDING_REMOVE: 
                case REMOVED: {
                    event = FlowRuleManager.this.store.removeFlowRule(stored);
                    break;
                }
            }
            if (event != null) {
                FlowRuleManager.this.log.debug("Flow {} removed", (Object)flowEntry);
                FlowRuleManager.this.post((Event)event);
            }
        }

        private void flowMissing(FlowEntry flowRule) {
            Preconditions.checkNotNull((Object)flowRule, (Object)FlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            FlowRuleProvider frp = FlowRuleManager.this.getProvider(flowRule.deviceId());
            FlowRuleEvent event = null;
            switch (flowRule.state()) {
                case PENDING_REMOVE: 
                case REMOVED: {
                    event = FlowRuleManager.this.store.removeFlowRule(flowRule);
                    break;
                }
                case ADDED: 
                case PENDING_ADD: {
                    event = FlowRuleManager.this.store.pendingFlowRule(flowRule);
                    try {
                        frp.applyFlowRule(new FlowRule[]{flowRule});
                    }
                    catch (UnsupportedOperationException e) {
                        FlowRuleManager.this.log.warn(e.getMessage());
                        if (!(flowRule instanceof DefaultFlowEntry)) break;
                        ((DefaultFlowEntry)flowRule).setState(FlowEntry.FlowEntryState.FAILED);
                    }
                    break;
                }
                default: {
                    FlowRuleManager.this.log.debug("Flow {} has not been installed.", (Object)flowRule);
                }
            }
            if (event != null) {
                FlowRuleManager.this.log.debug("Flow {} removed", (Object)flowRule);
                FlowRuleManager.this.post((Event)event);
            }
        }

        private void extraneousFlow(FlowRule flowRule) {
            Preconditions.checkNotNull((Object)flowRule, (Object)FlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            FlowRuleProvider frp = FlowRuleManager.this.getProvider(flowRule.deviceId());
            frp.removeFlowRule(new FlowRule[]{flowRule});
            FlowRuleManager.this.log.debug("Flow {} is on switch but not in store.", (Object)flowRule);
        }

        private void flowAdded(FlowEntry flowEntry) {
            Preconditions.checkNotNull((Object)flowEntry, (Object)FlowRuleManager.FLOW_RULE_NULL);
            this.checkValidity();
            if (this.checkRuleLiveness(flowEntry, FlowRuleManager.this.store.getFlowEntry((FlowRule)flowEntry))) {
                FlowRuleEvent event = FlowRuleManager.this.store.addOrUpdateFlowRule(flowEntry);
                if (event == null) {
                    FlowRuleManager.this.log.debug("No flow store event generated.");
                } else {
                    FlowRuleManager.this.log.trace("Flow {} {}", (Object)flowEntry, (Object)event.type());
                    FlowRuleManager.this.post((Event)event);
                }
            } else {
                FlowRuleManager.this.log.debug("Removing flow rules....");
                FlowRuleManager.this.removeFlowRules(new FlowRule[]{flowEntry});
            }
        }

        private boolean checkRuleLiveness(FlowEntry swRule, FlowEntry storedRule) {
            Long last;
            if (storedRule == null) {
                return false;
            }
            if (storedRule.isPermanent()) {
                return true;
            }
            long timeout = storedRule.timeout() * 1000;
            long currentTime = System.currentTimeMillis();
            if (storedRule.hardTimeout() != 0) {
                if (!this.firstSeen.containsKey(storedRule)) {
                    this.firstSeen.put(storedRule, currentTime);
                } else {
                    Long first = this.firstSeen.get(storedRule);
                    long hardTimeout = storedRule.hardTimeout() * 1000;
                    if (currentTime - first > hardTimeout) {
                        return false;
                    }
                }
            }
            if (storedRule.packets() != swRule.packets()) {
                this.lastSeen.put(storedRule, currentTime);
                return true;
            }
            if (!this.lastSeen.containsKey(storedRule)) {
                this.lastSeen.put(storedRule, storedRule.lastSeen());
            }
            return (last = this.lastSeen.get(storedRule)) != null && currentTime - last <= timeout;
        }

        public void pushFlowMetrics(DeviceId deviceId, Iterable<FlowEntry> flowEntries) {
            this.pushFlowMetricsInternal(deviceId, flowEntries, true);
        }

        public void pushFlowMetricsWithoutFlowMissing(DeviceId deviceId, Iterable<FlowEntry> flowEntries) {
            this.pushFlowMetricsInternal(deviceId, flowEntries, false);
        }

        private void pushFlowMetricsInternal(DeviceId deviceId, Iterable<FlowEntry> flowEntries, boolean useMissingFlow) {
            HashMap storedRules = Maps.newHashMap();
            FlowRuleManager.this.store.getFlowEntries(deviceId).forEach(f -> storedRules.put(f, f));
            for (FlowEntry rule : flowEntries) {
                try {
                    FlowEntry storedRule = (FlowEntry)storedRules.remove(rule);
                    if (storedRule != null) {
                        if (storedRule.exactMatch((FlowRule)rule)) {
                            this.flowAdded(rule);
                            continue;
                        }
                        this.extraneousFlow((FlowRule)rule);
                        this.flowMissing(storedRule);
                        continue;
                    }
                    if (FlowRuleManager.this.allowExtraneousRules) continue;
                    this.extraneousFlow((FlowRule)rule);
                }
                catch (Exception e) {
                    FlowRuleManager.this.log.debug("Can't process added or extra rule {}", (Object)e.getMessage());
                }
            }
            if (useMissingFlow) {
                for (FlowEntry rule : storedRules.keySet()) {
                    try {
                        FlowRuleManager.this.log.debug("Adding rule in store, but not on switch {}", (Object)rule);
                        this.flowMissing(rule);
                    }
                    catch (Exception e) {
                        FlowRuleManager.this.log.debug("Can't add missing flow rule:", (Throwable)e);
                    }
                }
            }
        }

        public void batchOperationCompleted(long batchId, CompletedBatchOperation operation) {
            FlowRuleManager.this.store.batchOperationComplete(FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(batchId, Collections.emptySet()), (CompletedBatchOperation)operation));
        }

        public void pushTableStatistics(DeviceId deviceId, List<TableStatisticsEntry> tableStats) {
            FlowRuleManager.this.store.updateTableStatistics(deviceId, tableStats);
        }
    }
}

