/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleProgrammable;
import org.onosproject.net.flow.FlowRuleProvider;
import org.onosproject.net.flow.FlowRuleProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlowRuleDriverProvider
extends AbstractProvider
implements FlowRuleProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String SCHEME = "default";
    public static final String PROVIDER_NAME = "org.onosproject.provider";
    FlowRuleProviderService providerService;
    private DeviceService deviceService;
    private MastershipService mastershipService;
    private InternalDeviceListener deviceListener = new InternalDeviceListener();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"FlowRuleDriverProvider", (String)"%d", (Logger)this.log));
    private ScheduledFuture<?> poller = null;
    private static final Set<DeviceEvent.Type> POSITIVE_DEVICE_EVENT = Sets.immutableEnumSet((Enum)DeviceEvent.Type.DEVICE_ADDED, (Enum[])new DeviceEvent.Type[]{DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED});

    FlowRuleDriverProvider() {
        super(new ProviderId(SCHEME, PROVIDER_NAME));
    }

    void init(FlowRuleProviderService providerService, DeviceService deviceService, MastershipService mastershipService, int pollFrequency) {
        this.providerService = providerService;
        this.deviceService = deviceService;
        this.mastershipService = mastershipService;
        deviceService.addListener((EventListener)this.deviceListener);
        if (this.poller != null && !this.poller.isCancelled()) {
            this.poller.cancel(false);
        }
        this.poller = this.executor.scheduleAtFixedRate(this::pollFlowEntries, pollFrequency, pollFrequency, TimeUnit.SECONDS);
    }

    public void applyFlowRule(FlowRule ... flowRules) {
        this.rulesByDevice(flowRules).asMap().forEach(this::applyFlowRules);
    }

    public void removeFlowRule(FlowRule ... flowRules) {
        this.rulesByDevice(flowRules).asMap().forEach(this::removeFlowRules);
    }

    public void removeRulesById(ApplicationId id, FlowRule ... flowRules) {
        this.removeFlowRule(flowRules);
    }

    public void executeBatch(FlowRuleBatchOperation batch) {
        ImmutableList.Builder toAdd = ImmutableList.builder();
        ImmutableList.Builder toRemove = ImmutableList.builder();
        for (FlowRuleBatchEntry fbe : batch.getOperations()) {
            if (fbe.operator() == FlowRuleBatchEntry.FlowRuleOperation.ADD || fbe.operator() == FlowRuleBatchEntry.FlowRuleOperation.MODIFY) {
                toAdd.add(fbe.target());
                continue;
            }
            if (fbe.operator() != FlowRuleBatchEntry.FlowRuleOperation.REMOVE) continue;
            toRemove.add(fbe.target());
        }
        ImmutableList rulesToAdd = toAdd.build();
        ImmutableList rulesToRemove = toRemove.build();
        Object added = ImmutableList.of();
        if (!rulesToAdd.isEmpty()) {
            added = this.applyFlowRules(batch.deviceId(), (Collection<FlowRule>)rulesToAdd);
        }
        Object removed = ImmutableList.of();
        if (!rulesToRemove.isEmpty()) {
            removed = this.removeFlowRules(batch.deviceId(), (Collection<FlowRule>)rulesToRemove);
        }
        Sets.SetView failedRules = Sets.union((Set)Sets.difference((Set)ImmutableSet.copyOf((Collection)rulesToAdd), (Set)ImmutableSet.copyOf((Collection)added)), (Set)Sets.difference((Set)ImmutableSet.copyOf((Collection)rulesToRemove), (Set)ImmutableSet.copyOf((Collection)removed)));
        CompletedBatchOperation status = new CompletedBatchOperation(failedRules.isEmpty(), (Set)failedRules, batch.deviceId());
        this.providerService.batchOperationCompleted(batch.id(), status);
    }

    private Multimap<DeviceId, FlowRule> rulesByDevice(FlowRule[] flowRules) {
        LinkedListMultimap rulesByDevice = LinkedListMultimap.create();
        for (FlowRule rule : flowRules) {
            rulesByDevice.put((Object)rule.deviceId(), (Object)rule);
        }
        return rulesByDevice;
    }

    private Collection<FlowRule> applyFlowRules(DeviceId deviceId, Collection<FlowRule> flowRules) {
        FlowRuleProgrammable programmer = this.getFlowRuleProgrammable(deviceId);
        return programmer != null ? programmer.applyFlowRules(flowRules) : ImmutableList.of();
    }

    private Collection<FlowRule> removeFlowRules(DeviceId deviceId, Collection<FlowRule> flowRules) {
        FlowRuleProgrammable programmer = this.getFlowRuleProgrammable(deviceId);
        return programmer != null ? programmer.removeFlowRules(flowRules) : ImmutableList.of();
    }

    private FlowRuleProgrammable getFlowRuleProgrammable(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device.is(FlowRuleProgrammable.class)) {
            return (FlowRuleProgrammable)device.as(FlowRuleProgrammable.class);
        }
        this.log.debug("Device {} is not flow rule programmable", (Object)deviceId);
        return null;
    }

    private void pollDeviceFlowEntries(Device device) {
        try {
            this.providerService.pushFlowMetrics(device.id(), (Iterable)((FlowRuleProgrammable)device.as(FlowRuleProgrammable.class)).getFlowEntries());
        }
        catch (Exception e) {
            this.log.warn("Exception thrown while polling {}", (Object)device.id(), (Object)e);
        }
    }

    private void pollFlowEntries() {
        try {
            this.deviceService.getAvailableDevices().forEach(device -> {
                if (this.mastershipService.isLocalMaster(device.id()) && device.is(FlowRuleProgrammable.class)) {
                    this.pollDeviceFlowEntries((Device)device);
                }
            });
        }
        catch (Exception e) {
            this.log.warn("Exception thrown while polling flows", (Throwable)e);
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            FlowRuleDriverProvider.this.executor.execute(() -> this.handleEvent(event));
        }

        public boolean isRelevant(DeviceEvent event) {
            Device device = (Device)event.subject();
            return POSITIVE_DEVICE_EVENT.contains(event.type()) && device.is(FlowRuleProgrammable.class);
        }

        private void handleEvent(DeviceEvent event) {
            boolean isRelevant;
            Device device = (Device)event.subject();
            boolean bl = isRelevant = FlowRuleDriverProvider.this.mastershipService.isLocalMaster(device.id()) && FlowRuleDriverProvider.this.deviceService.isAvailable(device.id());
            if (isRelevant) {
                FlowRuleDriverProvider.this.pollDeviceFlowEntries(device);
            }
        }
    }
}

