/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.edgeservice.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.edge.EdgePortEvent;
import org.onosproject.net.edge.EdgePortListener;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class EdgeManager
extends AbstractListenerManager<EdgePortEvent, EdgePortListener>
implements EdgePortService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<DeviceId, Set<ConnectPoint>> connectionPoints = Maps.newConcurrentMap();
    private final DeviceListener deviceListener = new InnerDeviceListener();
    private final LinkListener linkListener = new InnerLinkListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(EdgePortEvent.class, (EventSink)this.listenerRegistry);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.loadAllEdgePorts();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.eventDispatcher.removeSink(EdgePortEvent.class);
        this.log.info("Stopped");
    }

    public boolean isEdgePoint(ConnectPoint point) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        Set<ConnectPoint> connectPoints = this.connectionPoints.get(point.deviceId());
        return connectPoints != null && connectPoints.contains(point);
    }

    public Iterable<ConnectPoint> getEdgePoints() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.connectionPoints.forEach((k, v) -> v.forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0)));
        return builder.build();
    }

    public Iterable<ConnectPoint> getEdgePoints(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.TOPOLOGY_READ);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set<ConnectPoint> set = this.connectionPoints.get(deviceId);
        if (set != null) {
            set.forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public void emitPacket(ByteBuffer data, Optional<TrafficTreatment> treatment) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        TrafficTreatment.Builder builder = treatment.map(DefaultTrafficTreatment::builder).orElse(DefaultTrafficTreatment.builder());
        this.getEdgePoints().forEach(p -> this.packetService.emit(this.packet(builder, (ConnectPoint)p, data)));
    }

    public void emitPacket(DeviceId deviceId, ByteBuffer data, Optional<TrafficTreatment> treatment) {
        TrafficTreatment.Builder builder = treatment.map(DefaultTrafficTreatment::builder).orElse(DefaultTrafficTreatment.builder());
        this.getEdgePoints(deviceId).forEach(p -> this.packetService.emit(this.packet(builder, (ConnectPoint)p, data)));
    }

    private OutboundPacket packet(TrafficTreatment.Builder builder, ConnectPoint point, ByteBuffer data) {
        builder.setOutput(point.port());
        return new DefaultOutboundPacket(point.deviceId(), builder.build(), data);
    }

    private void loadAllEdgePorts() {
        this.deviceService.getAvailableDevices().forEach(d -> this.deviceService.getPorts(d.id()).forEach(p -> this.addEdgePort(new ConnectPoint((ElementId)d.id(), p.number()))));
    }

    private void processLinkEvent(LinkEvent event) {
        boolean addEdgePort;
        boolean bl = addEdgePort = event.type() == LinkEvent.Type.LINK_REMOVED;
        if (((Link)event.subject()).type() == Link.Type.EDGE) {
            boolean bl2 = addEdgePort = !addEdgePort;
        }
        if (addEdgePort) {
            this.addEdgePort(((Link)event.subject()).src());
            this.addEdgePort(((Link)event.subject()).dst());
        } else {
            this.removeEdgePort(((Link)event.subject()).src());
            this.removeEdgePort(((Link)event.subject()).dst());
        }
    }

    private void processDeviceEvent(DeviceEvent event) {
        DeviceEvent.Type type = (DeviceEvent.Type)event.type();
        DeviceId id = ((Device)event.subject()).id();
        if (type == DeviceEvent.Type.DEVICE_ADDED || type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED && this.deviceService.isAvailable(id)) {
            this.deviceService.getPorts(((Device)event.subject()).id()).forEach(p -> this.addEdgePort(new ConnectPoint((ElementId)id, p.number())));
        } else if (type == DeviceEvent.Type.DEVICE_REMOVED || type == DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED && !this.deviceService.isAvailable(id)) {
            Optional.ofNullable(this.connectionPoints.remove(id)).orElse((Set<ConnectPoint>)ImmutableSet.of()).forEach(point -> this.post((Event)new EdgePortEvent(EdgePortEvent.Type.EDGE_PORT_REMOVED, point)));
        } else if (type == DeviceEvent.Type.PORT_ADDED || type == DeviceEvent.Type.PORT_UPDATED && event.port().isEnabled()) {
            this.addEdgePort(new ConnectPoint((ElementId)id, event.port().number()));
        } else if (type == DeviceEvent.Type.PORT_REMOVED || type == DeviceEvent.Type.PORT_UPDATED && !event.port().isEnabled()) {
            this.removeEdgePort(new ConnectPoint((ElementId)id, event.port().number()));
        }
    }

    private boolean isEdgePort(ConnectPoint point) {
        return !point.port().isLogical() && this.deviceService.getPort(point) != null && this.linkService.getLinks(point).stream().allMatch(link -> link.type() == Link.Type.EDGE);
    }

    private void addEdgePort(ConnectPoint point) {
        Set set;
        if (this.isEdgePort(point) && (set = this.connectionPoints.computeIfAbsent(point.deviceId(), k -> Sets.newConcurrentHashSet())).add(point)) {
            this.post((Event)new EdgePortEvent(EdgePortEvent.Type.EDGE_PORT_ADDED, point));
        }
    }

    private void removeEdgePort(ConnectPoint point) {
        if (!point.port().isLogical()) {
            Set<ConnectPoint> set = this.connectionPoints.get(point.deviceId());
            if (set == null) {
                return;
            }
            if (set.remove(point)) {
                this.post((Event)new EdgePortEvent(EdgePortEvent.Type.EDGE_PORT_REMOVED, point));
            }
            if (set.isEmpty()) {
                this.connectionPoints.computeIfPresent(point.deviceId(), (k, v) -> {
                    if (v.isEmpty()) {
                        return null;
                    }
                    return v;
                });
            }
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.PORT_STATS_UPDATED) {
                return;
            }
            EdgeManager.this.processDeviceEvent(event);
        }
    }

    private class InnerLinkListener
    implements LinkListener {
        private InnerLinkListener() {
        }

        public void event(LinkEvent event) {
            EdgeManager.this.processLinkEvent(event);
        }
    }
}

