/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Dictionary;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.incubator.component.ComponentService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriverProvider;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverAdminService;
import org.onosproject.net.driver.DriverProvider;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true, enabled=true)
public class DriverRegistryManager
extends DefaultDriverProvider
implements DriverAdminService {
    private static final String DRIVER_COMPONENT = "org.onosproject.net.driver.impl.DriverManager";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String FORMAT = "Required drivers: {}";
    private static final String COMMA = ",";
    private static final String NO_DRIVER = "Driver not found";
    private static final String DEFAULT = "default";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentService componenService;
    private static final String DEFAULT_REQUIRED_DRIVERS = "default";
    @Property(name="requiredDrivers", value={"default"}, label="Comma-separated list of drivers that must be registered before starting driver subsystem")
    private String requiredDrivers = "default";
    private Set<String> requiredDriverSet;
    private Set<DriverProvider> providers = Sets.newConcurrentHashSet();
    private Map<String, Driver> driverByKey = Maps.newConcurrentMap();
    private Map<String, Class<? extends Behaviour>> classes = Maps.newConcurrentMap();
    private boolean isStarted = false;

    @Activate
    protected void activate(ComponentContext context) {
        this.componentConfigService.registerProperties(((Object)((Object)this)).getClass());
        this.modified(context);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.componentConfigService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.providers.clear();
        this.driverByKey.clear();
        this.classes.clear();
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties;
        Dictionary dictionary = properties = context != null ? context.getProperties() : new Properties();
        if (context != null) {
            this.requiredDrivers = Tools.get((Dictionary)properties, (String)"requiredDrivers");
        }
        this.requiredDriverSet = Strings.isNullOrEmpty((String)this.requiredDrivers) ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])this.requiredDrivers.split(COMMA));
        this.log.info(FORMAT, (Object)this.requiredDrivers);
        this.checkRequiredDrivers();
    }

    public Set<DriverProvider> getProviders() {
        return ImmutableSet.copyOf(this.providers);
    }

    public void registerProvider(DriverProvider provider) {
        provider.getDrivers().forEach(driver -> {
            Driver d = this.addDriver((Driver)driver);
            this.driverByKey.put(DriverRegistryManager.key(driver.manufacturer(), driver.hwVersion(), driver.swVersion()), d);
            d.behaviours().forEach(b -> {
                Class implementation = d.implementation(b);
                this.classes.put(b.getName(), (Class<? extends Behaviour>)b);
                this.classes.put(implementation.getName(), implementation);
            });
        });
        this.providers.add(provider);
        this.checkRequiredDrivers();
    }

    public void unregisterProvider(DriverProvider provider) {
        provider.getDrivers().forEach(driver -> {
            this.removeDriver((Driver)driver);
            this.driverByKey.remove(DriverRegistryManager.key(driver.manufacturer(), driver.hwVersion(), driver.swVersion()));
        });
        this.providers.remove(provider);
        this.checkRequiredDrivers();
    }

    private synchronized void checkRequiredDrivers() {
        Set<String> driverSet = this.registeredDrivers();
        boolean isReady = driverSet.containsAll(this.requiredDriverSet);
        if (isReady && !this.isStarted) {
            this.log.info("Starting driver subsystem");
            this.componenService.activate(null, DRIVER_COMPONENT);
            this.isStarted = true;
        } else if (!isReady && this.isStarted) {
            this.log.info("Stopping driver subsystem");
            this.componenService.deactivate(null, DRIVER_COMPONENT);
            this.isStarted = false;
        }
    }

    private Set<String> registeredDrivers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DriverProvider dp : this.providers) {
            dp.getDrivers().stream().map(Driver::name).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public Class<? extends Behaviour> getBehaviourClass(String className) {
        return this.classes.get(className);
    }

    public Set<Driver> getDrivers() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.drivers.values().forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    public Driver getDriver(String mfr, String hw, String sw) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        Driver driver = this.driverByKey.get(DriverRegistryManager.key(mfr, hw, sw));
        if (driver != null) {
            return driver;
        }
        Optional<Driver> optional = this.driverByKey.values().stream().filter(d -> this.matches((Driver)d, mfr, hw, sw)).findFirst();
        return optional.orElse((Driver)this.drivers.get("default"));
    }

    public Driver getDriver(String driverName) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        return (Driver)Tools.nullIsNotFound(this.drivers.get(driverName), (String)NO_DRIVER);
    }

    private boolean matches(Driver d, String mfr, String hw, String sw) {
        return mfr.matches(d.manufacturer()) && hw.matches(d.hwVersion()) && sw.matches(d.swVersion());
    }

    static String key(String mfr, String hw, String sw) {
        return String.format("%s-%s-%s", mfr, hw, sw);
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindComponenService(ComponentService componentService) {
        this.componenService = componentService;
    }

    protected void unbindComponenService(ComponentService componentService) {
        if (this.componenService == componentService) {
            this.componenService = null;
        }
    }
}

