/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverRegistry;
import org.onosproject.net.driver.DriverService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true, enabled=false)
public class DriverManager
implements DriverService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String NO_DRIVER = "Driver not found";
    private static final String NO_DEVICE = "Device not found";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverRegistry registry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    protected void activate() {
        AbstractProjectableModel.setDriverService(null, (DriverService)this);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        AbstractProjectableModel.setDriverService((Object)this, null);
        this.log.info("Stopped");
    }

    public Set<Driver> getDrivers() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        return this.registry.getDrivers();
    }

    public Set<Driver> getDrivers(Class<? extends Behaviour> withBehaviour) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        return this.registry.getDrivers().stream().filter(d -> d.hasBehaviour(withBehaviour)).collect(Collectors.toSet());
    }

    public Driver getDriver(String driverName) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        return this.registry.getDriver(driverName);
    }

    public Driver getDriver(String mfr, String hw, String sw) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        return this.registry.getDriver(mfr, hw, sw);
    }

    public Driver getDriver(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_READ);
        Device device = (Device)Tools.nullIsNotFound((Object)this.deviceService.getDevice(deviceId), (String)NO_DEVICE);
        String driverName = device.annotations().value("driver");
        if (driverName != null) {
            try {
                return this.getDriver(driverName);
            }
            catch (ItemNotFoundException e) {
                this.log.warn("Specified driver {} not found, falling back.", (Object)driverName);
            }
        }
        return (Driver)Tools.nullIsNotFound((Object)this.getDriver(device.manufacturer(), device.hwVersion(), device.swVersion()), (String)NO_DRIVER);
    }

    public DriverHandler createHandler(DeviceId deviceId, String ... credentials) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DRIVER_WRITE);
        Driver driver = this.getDriver(deviceId);
        return new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, deviceId));
    }

    protected void bindRegistry(DriverRegistry driverRegistry) {
        this.registry = driverRegistry;
    }

    protected void unbindRegistry(DriverRegistry driverRegistry) {
        if (this.registry == driverRegistry) {
            this.registry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

