/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.domain.impl;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.domain.DomainId;
import org.onosproject.net.domain.DomainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DomainManager
implements DomainService {
    private static final String DOMAIN_ID = "domainId";
    private static final String LOCAL_DOMAIN = "local";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Set<DomainId> getDomainIds() {
        HashSet<DomainId> domIds = new HashSet<DomainId>();
        this.deviceService.getAvailableDevices().forEach(dev -> domIds.add(this.getAnnotatedDomainId((Device)dev)));
        return domIds;
    }

    public Set<DeviceId> getDeviceIds(DomainId domainId) {
        HashSet<DeviceId> domainIds = new HashSet<DeviceId>();
        this.deviceService.getAvailableDevices().forEach(dev -> {
            if (this.getAnnotatedDomainId((Device)dev).equals((Object)domainId)) {
                domainIds.add(dev.id());
            }
        });
        return domainIds;
    }

    public DomainId getDomain(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId);
        return (DomainId)Preconditions.checkNotNull((Object)this.getAnnotatedDomainId(this.deviceService.getDevice(deviceId)));
    }

    private DomainId getAnnotatedDomainId(Device device) {
        if (!device.annotations().keys().contains(DOMAIN_ID)) {
            return DomainId.LOCAL;
        }
        return DomainId.domainId((String)device.annotations().value(DOMAIN_ID));
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

