/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.domain.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.DomainIntentConfigurable;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.domain.DomainIntent;
import org.onosproject.net.domain.DomainIntentOperation;
import org.onosproject.net.domain.DomainIntentOperations;
import org.onosproject.net.domain.DomainIntentService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DomainIntentManager
implements DomainIntentService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Tools.groupedThreads((String)"onos/domain-intent-mgmt", (String)"%d", (Logger)this.log));
    private final Map<DeviceId, DriverHandler> driverHandlers = Maps.newConcurrentMap();
    private final Map<DeviceId, DomainIntentConfigurable> driversMap = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void sumbit(DomainIntentOperations domainOperations) {
        this.executorService.execute(new DomainIntentProcessor(domainOperations));
    }

    private DomainIntentConfigurable getDomainIntentConfigurable(DeviceId deviceId) {
        return this.driversMap.computeIfAbsent(deviceId, this::initDomainIntentDriver);
    }

    private DomainIntentConfigurable initDomainIntentDriver(DeviceId deviceId) {
        DriverHandler handler = this.driverHandlers.get(deviceId);
        if (handler == null) {
            try {
                handler = this.driverService.createHandler(deviceId, new String[0]);
                if (!handler.driver().hasBehaviour(DomainIntentConfigurable.class)) {
                    this.log.warn("DomainIntentConfig behaviour not supported for device {}", (Object)deviceId);
                    return null;
                }
            }
            catch (ItemNotFoundException e) {
                this.log.warn("No applicable driver for device {}", (Object)deviceId);
                return null;
            }
            this.driverHandlers.put(deviceId, handler);
        }
        this.log.info("Driver {} bound to device {} ... initializing driver", (Object)handler.driver().name(), (Object)deviceId);
        return (DomainIntentConfigurable)handler.behaviour(DomainIntentConfigurable.class);
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    private class DomainIntentProcessor
    implements Runnable {
        private final DomainIntentOperations idos;
        private final List<DomainIntentOperation> stages;
        private boolean hasFailed = false;

        public DomainIntentProcessor(DomainIntentOperations dios) {
            this.idos = (DomainIntentOperations)Preconditions.checkNotNull((Object)dios);
            this.stages = Lists.newArrayList((Iterable)((Iterable)Preconditions.checkNotNull((Object)dios.stages())));
        }

        @Override
        public synchronized void run() {
            if (this.stages.size() > 0) {
                this.process(this.stages.remove(0));
            } else if (!this.hasFailed) {
                this.idos.callback().onSuccess(this.idos);
            }
        }

        private void process(DomainIntentOperation dio) {
            Optional<DomainIntentConfigurable> config = dio.intent().filteredIngressPoints().stream().map(x -> DomainIntentManager.this.getDomainIntentConfigurable(x.connectPoint().deviceId())).filter(Objects::nonNull).findAny();
            DomainIntent domainIntent = null;
            if (config.isPresent()) {
                if (dio.type() == DomainIntentOperation.Type.ADD) {
                    domainIntent = config.get().sumbit(dio.intent());
                } else if (dio.type() == DomainIntentOperation.Type.REMOVE) {
                    domainIntent = config.get().remove(dio.intent());
                }
                DomainIntentManager.this.executorService.execute(this);
            } else {
                DomainIntentManager.this.log.error("Ingresses devices does not support DomainIntentConfigurable. Installation failed");
                this.hasFailed = true;
            }
            if (domainIntent == null) {
                DomainIntentManager.this.log.error("Installation failed for Domain Intent {}", (Object)dio.intent());
                this.hasFailed = true;
            }
            if (this.hasFailed) {
                DomainIntentOperations failedBuilder = DomainIntentOperations.builder().add(dio.intent()).build();
                this.idos.callback().onError(failedBuilder);
                DomainIntentManager.this.executorService.execute(this);
            }
        }
    }
}

