/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device.impl;

import java.util.Map;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.PortConfigOperator;
import org.onosproject.net.config.basics.PortAnnotationConfig;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;

public class PortAnnotationOperator
implements PortConfigOperator {
    private NetworkConfigService networkConfigService;

    public PortAnnotationOperator() {
    }

    PortAnnotationOperator(NetworkConfigService networkConfigService) {
        this.bindService(networkConfigService);
    }

    public void bindService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    private PortAnnotationConfig lookupConfig(ConnectPoint cp) {
        if (this.networkConfigService == null) {
            return null;
        }
        return (PortAnnotationConfig)this.networkConfigService.getConfig((Object)cp, PortAnnotationConfig.class);
    }

    public PortDescription combine(ConnectPoint cp, PortDescription descr) {
        PortAnnotationConfig cfg = this.lookupConfig(cp);
        if (cfg == null) {
            return descr;
        }
        Map annotations = cfg.annotations();
        if (annotations.isEmpty()) {
            return descr;
        }
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.putAll((Annotations)descr.annotations());
        builder.putAll(annotations);
        return DefaultPortDescription.copyReplacingAnnotation((PortDescription)descr, (SparseAnnotations)builder.build());
    }
}

