/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.Futures;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.joda.time.DateTime;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.PortConfigOperator;
import org.onosproject.net.config.PortConfigOperatorRegistry;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.config.basics.PortAnnotationConfig;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreDelegate;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.device.impl.BasicDeviceOperator;
import org.onosproject.net.device.impl.PortAnnotationOperator;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DeviceManager
extends AbstractListenerProviderRegistry<DeviceEvent, DeviceListener, DeviceProvider, DeviceProviderService>
implements DeviceService,
DeviceAdminService,
DeviceProviderRegistry,
PortConfigOperatorRegistry {
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String PORT_NUMBER_NULL = "Port number cannot be null";
    private static final String DEVICE_DESCRIPTION_NULL = "Device description cannot be null";
    private static final String PORT_DESCRIPTION_NULL = "Port description cannot be null";
    private static final String PORT_DESC_LIST_NULL = "Port description list cannot be null";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DeviceStoreDelegate delegate = new InternalStoreDelegate();
    private final MastershipListener mastershipListener = new InternalMastershipListener();
    private NodeId localNodeId;
    private ScheduledExecutorService backgroundService;
    private final NetworkConfigListener networkConfigListener = new InternalNetworkConfigListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipTermService termService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    private final List<PortConfigOperator> portOps = new CopyOnWriteArrayList<PortConfigOperator>();
    private final Multimap<Class<? extends Config<ConnectPoint>>, PortConfigOperator> portOpsIndex = Multimaps.synchronizedListMultimap((ListMultimap)Multimaps.newListMultimap(new ConcurrentHashMap(), CopyOnWriteArrayList::new));
    private PortAnnotationOperator portAnnotationOp;
    private final Map<DeviceId, LocalStatus> deviceLocalStatus = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.portAnnotationOp = new PortAnnotationOperator(this.networkConfigService);
        this.portOpsIndex.put(PortAnnotationConfig.class, (Object)this.portAnnotationOp);
        this.backgroundService = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/device", (String)"manager-background", (Logger)this.log));
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(DeviceEvent.class, (EventSink)this.listenerRegistry);
        this.mastershipService.addListener((EventListener)this.mastershipListener);
        this.networkConfigService.addListener((EventListener)this.networkConfigListener);
        this.backgroundService.scheduleWithFixedDelay(() -> {
            try {
                this.mastershipCheck();
            }
            catch (Exception e) {
                this.log.error("Exception thrown during integrity check", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.backgroundService.shutdown();
        this.networkConfigService.removeListener((EventListener)this.networkConfigListener);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.mastershipService.removeListener((EventListener)this.mastershipListener);
        this.eventDispatcher.removeSink(DeviceEvent.class);
        this.log.info("Stopped");
    }

    public int getDeviceCount() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        return this.store.getDeviceCount();
    }

    public Iterable<Device> getDevices() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        return this.store.getDevices();
    }

    public Iterable<Device> getAvailableDevices() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        return this.store.getAvailableDevices();
    }

    public Device getDevice(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getDevice(deviceId);
    }

    public MastershipRole getRole(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.mastershipService.getLocalRole(deviceId);
    }

    public List<Port> getPorts(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getPorts(deviceId);
    }

    public List<PortStatistics> getPortStatistics(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getPortStatistics(deviceId);
    }

    public List<PortStatistics> getPortDeltaStatistics(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getPortDeltaStatistics(deviceId);
    }

    public PortStatistics getStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)PORT_NUMBER_NULL);
        return this.store.getStatisticsForPort(deviceId, portNumber);
    }

    public PortStatistics getDeltaStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)PORT_NUMBER_NULL);
        return this.store.getDeltaStatisticsForPort(deviceId, portNumber);
    }

    public Port getPort(DeviceId deviceId, PortNumber portNumber) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)portNumber, (Object)PORT_NUMBER_NULL);
        return this.store.getPort(deviceId, portNumber);
    }

    public boolean isAvailable(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.isAvailable(deviceId);
    }

    public String localStatus(DeviceId deviceId) {
        LocalStatus ls = this.deviceLocalStatus.get(deviceId);
        if (ls == null) {
            return "No Record";
        }
        String timeAgo = Tools.timeAgo((long)ls.dateTime.getMillis());
        return ls.connected ? "connected " + timeAgo : "disconnected " + timeAgo;
    }

    private boolean isReachable(DeviceId deviceId) {
        if (deviceId == null) {
            return false;
        }
        DeviceProvider provider = (DeviceProvider)this.getProvider(deviceId);
        if (provider != null) {
            return provider.isReachable(deviceId);
        }
        this.log.debug("Provider not found for {}", (Object)deviceId);
        return false;
    }

    public void removeDevice(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        DeviceEvent event = this.store.removeDevice(deviceId);
        if (event != null) {
            this.log.info("Device {} administratively removed", (Object)deviceId);
            this.post((Event)event);
        }
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)PORT_NUMBER_NULL);
        DeviceProvider provider = (DeviceProvider)this.getProvider(deviceId);
        if (provider != null) {
            this.log.warn("Port {} on device {} being administratively brought {}", new Object[]{portNumber, deviceId, enable ? "UP" : "DOWN"});
            provider.changePortState(deviceId, portNumber, enable);
        } else {
            this.log.warn("Provider not found for {}", (Object)deviceId);
        }
    }

    protected DeviceProviderService createProviderService(DeviceProvider provider) {
        return new InternalDeviceProviderService(provider);
    }

    private void mastershipCheck() {
        this.log.debug("Checking mastership");
        for (Device device : this.getDevices()) {
            DeviceId deviceId = device.id();
            MastershipRole myRole = this.mastershipService.getLocalRole(deviceId);
            this.log.trace("Checking device {}. Current role is {}", (Object)deviceId, (Object)myRole);
            if (!this.isReachable(deviceId)) {
                if (myRole != MastershipRole.NONE) {
                    try {
                        if (myRole == MastershipRole.MASTER) {
                            this.post((Event)this.store.markOffline(deviceId));
                        }
                        this.mastershipService.relinquishMastership(deviceId).get();
                    }
                    catch (InterruptedException e) {
                        this.log.warn("Interrupted while reliquishing role for {}", (Object)deviceId);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.log.error("Exception thrown while relinquishing role for {}", (Object)deviceId, (Object)e);
                    }
                    continue;
                }
                CompletableFuture roleFuture = this.mastershipService.requestRoleFor(deviceId);
                roleFuture.thenAccept(role -> {
                    MastershipTerm term = this.termService.getMastershipTerm(deviceId);
                    if (term != null && this.localNodeId.equals((Object)term.master())) {
                        this.log.info("Marking unreachable device {} offline", (Object)deviceId);
                        this.post((Event)this.store.markOffline(deviceId));
                    } else {
                        this.log.info("Failed marking {} offline. {}", (Object)deviceId, role);
                    }
                    this.mastershipService.relinquishMastership(deviceId);
                });
                continue;
            }
            if (myRole != MastershipRole.NONE) continue;
            this.log.info("{} is reachable but did not have a valid role, reasserting", (Object)deviceId);
            this.reassertRole(deviceId, MastershipRole.NONE);
        }
    }

    private boolean isAllowed(BasicDeviceConfig cfg) {
        return cfg == null || cfg.isAllowed();
    }

    private boolean applyRoleAndProbe(DeviceId deviceId, MastershipRole newRole) {
        if (newRole.equals((Object)MastershipRole.NONE)) {
            return true;
        }
        DeviceProvider provider = (DeviceProvider)this.getProvider(deviceId);
        if (provider == null) {
            this.log.warn("Provider for {} was not found. Cannot apply role {}", (Object)deviceId, (Object)newRole);
            return false;
        }
        provider.roleChanged(deviceId, newRole);
        if (newRole.equals((Object)MastershipRole.MASTER)) {
            this.log.debug("sent TriggerProbe({})", (Object)deviceId);
            provider.triggerProbe(deviceId);
        }
        return true;
    }

    private void reassertRole(DeviceId did, MastershipRole nextRole) {
        MastershipRole myNextRole = nextRole;
        if (myNextRole == MastershipRole.NONE) {
            try {
                this.mastershipService.requestRoleFor(did).get();
                MastershipTerm term = this.termService.getMastershipTerm(did);
                myNextRole = term != null && this.localNodeId.equals((Object)term.master()) ? MastershipRole.MASTER : MastershipRole.STANDBY;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.error("Interrupted waiting for Mastership", (Throwable)e);
            }
            catch (ExecutionException e) {
                this.log.error("Encountered an error waiting for Mastership", (Throwable)e);
            }
        }
        switch (myNextRole) {
            case MASTER: {
                Device device = this.getDevice(did);
                if (device != null && !this.isAvailable(did)) {
                    this.store.markOnline(did);
                }
                this.log.debug("Applying role {} to {}", (Object)myNextRole, (Object)did);
                if (this.applyRoleAndProbe(did, MastershipRole.MASTER)) break;
                this.log.warn("Unsuccessful applying role {} to {}", (Object)myNextRole, (Object)did);
                this.mastershipService.relinquishMastership(did);
                break;
            }
            case STANDBY: {
                this.log.debug("Applying role {} to {}", (Object)myNextRole, (Object)did);
                if (this.applyRoleAndProbe(did, MastershipRole.STANDBY)) break;
                this.log.warn("Unsuccessful applying role {} to {}", (Object)myNextRole, (Object)did);
                this.mastershipService.relinquishMastership(did);
                break;
            }
            default: {
                this.log.error("You didn't see anything. I did not exist.");
            }
        }
    }

    private void handleMastershipEvent(MastershipEvent event) {
        MastershipRole myNextRole;
        if (event.type() == MastershipEvent.Type.BACKUPS_CHANGED) {
            return;
        }
        DeviceId did = (DeviceId)event.subject();
        if (event.type() == MastershipEvent.Type.SUSPENDED) {
            myNextRole = MastershipRole.NONE;
        } else if (this.localNodeId.equals((Object)event.roleInfo().master())) {
            boolean iHaveControl;
            MastershipTerm term = this.termService.getMastershipTerm(did);
            boolean bl = iHaveControl = term != null && this.localNodeId.equals((Object)term.master());
            myNextRole = iHaveControl ? MastershipRole.MASTER : MastershipRole.STANDBY;
        } else {
            myNextRole = event.roleInfo().backups().contains(this.localNodeId) ? MastershipRole.STANDBY : MastershipRole.NONE;
        }
        boolean isReachable = this.isReachable(did);
        if (!isReachable) {
            if (this.mastershipService.getLocalRole(did) == MastershipRole.NONE) {
                this.log.debug("Node was instructed to be {} role for {}, but this node cannot reach the device and role is already None. Ignoring request.", (Object)myNextRole, (Object)did);
            } else if (myNextRole != MastershipRole.NONE) {
                this.log.warn("Node was instructed to be {} role for {}, but this node cannot reach the device.  Relinquishing role.  ", (Object)myNextRole, (Object)did);
                this.mastershipService.relinquishMastership(did);
            }
            return;
        }
        if (this.store.getDevice(did) != null) {
            this.reassertRole(did, myNextRole);
        } else {
            this.log.debug("Device is not yet/no longer in the store: {}", (Object)did);
        }
    }

    public Iterable<Device> getDevices(Device.Type type) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        HashSet<Device> results = new HashSet<Device>();
        Iterable devices = this.store.getDevices();
        if (devices != null) {
            devices.forEach(d -> {
                if (type.equals((Object)d.type())) {
                    results.add((Device)d);
                }
            });
        }
        return results;
    }

    public Iterable<Device> getAvailableDevices(Device.Type type) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.DEVICE_READ);
        HashSet<Device> results = new HashSet<Device>();
        Iterable availableDevices = this.store.getAvailableDevices();
        if (availableDevices != null) {
            availableDevices.forEach(d -> {
                if (type.equals((Object)d.type())) {
                    results.add((Device)d);
                }
            });
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final void registerPortConfigOperator(PortConfigOperator portOp, Class<? extends Config<ConnectPoint>> ... configs) {
        Preconditions.checkNotNull((Object)portOp);
        portOp.bindService(this.networkConfigService);
        Multimap<Class<? extends Config<ConnectPoint>>, PortConfigOperator> multimap = this.portOpsIndex;
        synchronized (multimap) {
            for (Class<? extends Config<ConnectPoint>> config : configs) {
                this.portOpsIndex.put(config, (Object)portOp);
            }
            this.portOps.add(portOp);
        }
        Tools.stream((Iterable)this.store.getAvailableDevices()).map(Device::id).filter(arg_0 -> ((MastershipService)this.mastershipService).isLocalMaster(arg_0)).map(did -> {
            ProviderId pid = Optional.ofNullable(this.getProvider((DeviceId)did)).map(Provider::id).orElse(null);
            if (pid == null) {
                this.log.warn("Provider not found for {}", did);
                return ImmutableList.of();
            }
            List pds = this.store.getPortDescriptions(pid, did).map(pdesc -> this.applyAllPortOps((DeviceId)did, (PortDescription)pdesc)).collect(Collectors.toList());
            return this.store.updatePorts(pid, did, pds);
        }).forEach(evts -> evts.forEach(arg_0 -> ((DeviceManager)this).post(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortConfigOperator(PortConfigOperator portOp) {
        Preconditions.checkNotNull((Object)portOp);
        Multimap<Class<? extends Config<ConnectPoint>>, PortConfigOperator> multimap = this.portOpsIndex;
        synchronized (multimap) {
            this.portOps.remove(portOp);
            this.portOpsIndex.keySet().forEach(key -> this.portOpsIndex.remove(key, (Object)portOp));
        }
    }

    private PortDescription applyAllPortOps(DeviceId did, PortDescription desc) {
        return this.applyAllPortOps(new ConnectPoint((ElementId)did, desc.portNumber()), desc);
    }

    private PortDescription applyAllPortOps(ConnectPoint cpt, PortDescription desc) {
        PortDescription work = desc;
        for (PortConfigOperator portOp : this.portOps) {
            work = portOp.combine(cpt, work);
        }
        return this.portAnnotationOp.combine(cpt, work);
    }

    protected void bindStore(DeviceStore deviceStore) {
        this.store = deviceStore;
    }

    protected void unbindStore(DeviceStore deviceStore) {
        if (this.store == deviceStore) {
            this.store = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindTermService(MastershipTermService mastershipTermService) {
        this.termService = mastershipTermService;
    }

    protected void unbindTermService(MastershipTermService mastershipTermService) {
        if (this.termService == mastershipTermService) {
            this.termService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return !(event.type() != NetworkConfigEvent.Type.CONFIG_ADDED && event.type() != NetworkConfigEvent.Type.CONFIG_UPDATED || !event.configClass().equals(BasicDeviceConfig.class) && !DeviceManager.this.portOpsIndex.containsKey((Object)event.configClass()));
        }

        public void event(NetworkConfigEvent event) {
            DeviceEvent de = null;
            if (event.configClass().equals(BasicDeviceConfig.class)) {
                DeviceManager.this.log.debug("Detected device network config event {}", (Object)event.type());
                DeviceId did = (DeviceId)event.subject();
                DeviceProvider dp = (DeviceProvider)DeviceManager.this.getProvider(did);
                BasicDeviceConfig cfg = (BasicDeviceConfig)DeviceManager.this.networkConfigService.getConfig((Object)did, BasicDeviceConfig.class);
                if (!DeviceManager.this.isAllowed(cfg)) {
                    this.kickOutBadDevice(did);
                } else {
                    Device dev = DeviceManager.this.getDevice(did);
                    DeviceDescription desc2 = dev == null ? null : BasicDeviceOperator.descriptionOf(dev);
                    if ((desc2 = BasicDeviceOperator.combine(cfg, desc2)) != null && dp != null) {
                        de = DeviceManager.this.store.createOrUpdateDevice(dp.id(), did, desc2);
                    }
                }
            }
            if (DeviceManager.this.portOpsIndex.containsKey((Object)event.configClass())) {
                ConnectPoint cpt = (ConnectPoint)event.subject();
                DeviceId did = cpt.deviceId();
                DeviceProvider dp = (DeviceProvider)DeviceManager.this.getProvider(did);
                de = Optional.ofNullable(dp).map(provider -> DeviceManager.this.store.getPortDescription(provider.id(), did, cpt.port())).map(desc -> DeviceManager.this.applyAllPortOps(cpt, desc)).map(desc -> DeviceManager.this.store.updatePortStatus(dp.id(), did, desc)).orElse(null);
            }
            if (de != null) {
                DeviceManager.this.post(de);
            }
        }

        private void kickOutBadDevice(DeviceId deviceId) {
            Device badDevice = DeviceManager.this.getDevice(deviceId);
            if (badDevice != null) {
                DeviceManager.this.removeDevice(deviceId);
            }
        }
    }

    private class InternalStoreDelegate
    implements DeviceStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(DeviceEvent event) {
            DeviceManager.this.post((Event)event);
        }
    }

    private class InternalMastershipListener
    implements MastershipListener {
        private InternalMastershipListener() {
        }

        public void event(MastershipEvent event) {
            DeviceManager.this.backgroundService.execute(() -> {
                try {
                    DeviceManager.this.handleMastershipEvent(event);
                }
                catch (Exception e) {
                    DeviceManager.this.log.warn("Failed to handle {}", (Object)event, (Object)e);
                }
            });
        }
    }

    private class InternalDeviceProviderService
    extends AbstractProviderService<DeviceProvider>
    implements DeviceProviderService {
        InternalDeviceProviderService(DeviceProvider provider) {
            super((Provider)provider);
        }

        private boolean applyRole(DeviceId deviceId, MastershipRole newRole) {
            if (newRole.equals((Object)MastershipRole.NONE)) {
                return true;
            }
            DeviceProvider provider = (DeviceProvider)this.provider();
            if (provider == null) {
                DeviceManager.this.log.warn("Provider for {} was not found. Cannot apply role {}", (Object)deviceId, (Object)newRole);
                return false;
            }
            provider.roleChanged(deviceId, newRole);
            return true;
        }

        public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
            Preconditions.checkNotNull((Object)deviceId, (Object)DeviceManager.DEVICE_ID_NULL);
            Preconditions.checkNotNull((Object)deviceDescription, (Object)DeviceManager.DEVICE_DESCRIPTION_NULL);
            this.checkValidity();
            DeviceManager.this.deviceLocalStatus.put(deviceId, new LocalStatus(true, DateTime.now()));
            BasicDeviceConfig cfg = (BasicDeviceConfig)DeviceManager.this.networkConfigService.getConfig((Object)deviceId, BasicDeviceConfig.class);
            if (!DeviceManager.this.isAllowed(cfg)) {
                DeviceManager.this.log.warn("Device {} is not allowed", (Object)deviceId);
                return;
            }
            deviceDescription = BasicDeviceOperator.combine(cfg, deviceDescription);
            Futures.getUnchecked((Future)((Object)DeviceManager.this.mastershipService.requestRoleFor(deviceId).thenAccept(role -> {
                DeviceManager.this.log.info("Local role is {} for {}", role, (Object)deviceId);
                this.applyRole(deviceId, (MastershipRole)role);
            })));
            DeviceEvent event = DeviceManager.this.store.createOrUpdateDevice(((DeviceProvider)this.provider()).id(), deviceId, deviceDescription);
            if (deviceDescription.isDefaultAvailable()) {
                DeviceManager.this.log.info("Device {} connected", (Object)deviceId);
            } else {
                DeviceManager.this.log.info("Device {} registered", (Object)deviceId);
            }
            if (event != null) {
                DeviceManager.this.log.trace("event: {} {}", (Object)event.type(), (Object)event);
                DeviceManager.this.post((Event)event);
            }
        }

        private PortDescription ensurePortEnabledState(PortDescription desc, boolean enabled) {
            if (desc.isEnabled() != enabled) {
                return new DefaultPortDescription(desc.portNumber(), enabled, desc.type(), desc.portSpeed(), new SparseAnnotations[]{desc.annotations()});
            }
            return desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceDisconnected(DeviceId deviceId) {
            Preconditions.checkNotNull((Object)deviceId, (Object)DeviceManager.DEVICE_ID_NULL);
            this.checkValidity();
            DeviceManager.this.deviceLocalStatus.put(deviceId, new LocalStatus(false, DateTime.now()));
            DeviceManager.this.log.info("Device {} disconnected from this node", (Object)deviceId);
            List descs = DeviceManager.this.store.getPortDescriptions(((DeviceProvider)this.provider()).id(), deviceId).map(desc -> this.ensurePortEnabledState((PortDescription)desc, false)).collect(Collectors.toList());
            DeviceManager.this.store.updatePorts(((DeviceProvider)this.provider()).id(), deviceId, descs);
            try {
                if (DeviceManager.this.mastershipService.isLocalMaster(deviceId)) {
                    DeviceManager.this.post((Event)DeviceManager.this.store.markOffline(deviceId));
                }
            }
            catch (IllegalStateException e) {
                DeviceManager.this.log.warn("Failed to mark {} offline", (Object)deviceId);
                CompletableFuture roleFuture = DeviceManager.this.mastershipService.requestRoleFor(deviceId);
                roleFuture.whenComplete((role, error) -> {
                    MastershipTerm term = DeviceManager.this.termService.getMastershipTerm(deviceId);
                    if (term != null && DeviceManager.this.localNodeId.equals((Object)term.master())) {
                        DeviceManager.this.log.info("Retry marking {} offline", (Object)deviceId);
                        DeviceManager.this.post((Event)DeviceManager.this.store.markOffline(deviceId));
                    } else {
                        DeviceManager.this.log.info("Failed again marking {} offline. {}", (Object)deviceId, role);
                    }
                });
            }
            finally {
                try {
                    DeviceManager.this.mastershipService.relinquishMastership(deviceId).get();
                }
                catch (InterruptedException e) {
                    DeviceManager.this.log.warn("Interrupted while reliquishing role for {}", (Object)deviceId);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    DeviceManager.this.log.error("Exception thrown while relinquishing role for {}", (Object)deviceId, (Object)e);
                }
            }
        }

        public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
            Preconditions.checkNotNull((Object)deviceId, (Object)DeviceManager.DEVICE_ID_NULL);
            Preconditions.checkNotNull(portDescriptions, (Object)DeviceManager.PORT_DESC_LIST_NULL);
            this.checkValidity();
            if (!DeviceManager.this.mastershipService.isLocalMaster(deviceId)) {
                DeviceManager.this.log.trace("Ignoring {} port updates on standby node. {}", (Object)deviceId, portDescriptions);
                return;
            }
            portDescriptions = portDescriptions.stream().map(e -> DeviceManager.this.applyAllPortOps(deviceId, e)).collect(Collectors.toList());
            List events = DeviceManager.this.store.updatePorts(((DeviceProvider)this.provider()).id(), deviceId, portDescriptions);
            if (events != null) {
                for (DeviceEvent event : events) {
                    DeviceManager.this.post((Event)event);
                }
            }
        }

        public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
            Preconditions.checkNotNull((Object)deviceId, (Object)DeviceManager.DEVICE_ID_NULL);
            Preconditions.checkNotNull((Object)portDescription, (Object)DeviceManager.PORT_DESCRIPTION_NULL);
            this.checkValidity();
            if (!DeviceManager.this.mastershipService.isLocalMaster(deviceId)) {
                DeviceManager.this.log.trace("Ignoring {} port update on standby node. {}", (Object)deviceId, (Object)portDescription);
                return;
            }
            Device device = DeviceManager.this.getDevice(deviceId);
            if (device == null) {
                DeviceManager.this.log.trace("Device not found: {}", (Object)deviceId);
                return;
            }
            if (Device.Type.ROADM.equals((Object)device.type()) || Device.Type.OTN.equals((Object)device.type())) {
                PortDescription storedPortDesc = DeviceManager.this.store.getPortDescription(((DeviceProvider)this.provider()).id(), deviceId, portDescription.portNumber());
                portDescription = this.ensurePortEnabledState(storedPortDesc, portDescription.isEnabled());
            }
            portDescription = DeviceManager.this.applyAllPortOps(deviceId, portDescription);
            DeviceEvent event = DeviceManager.this.store.updatePortStatus(((DeviceProvider)this.provider()).id(), deviceId, portDescription);
            if (event != null) {
                DeviceManager.this.log.info("Device {} port {} status changed", (Object)deviceId, (Object)event.port().number());
                DeviceManager.this.post((Event)event);
            }
        }

        public void deletePort(DeviceId deviceId, PortDescription basePortDescription) {
            Preconditions.checkNotNull((Object)deviceId, (Object)DeviceManager.DEVICE_ID_NULL);
            Preconditions.checkNotNull((Object)basePortDescription, (Object)DeviceManager.PORT_DESCRIPTION_NULL);
            this.checkValidity();
            if (!DeviceManager.this.mastershipService.isLocalMaster(deviceId)) {
                DeviceManager.this.log.trace("Ignoring {} port update on standby node. {}", (Object)deviceId, (Object)basePortDescription);
                return;
            }
            Device device = DeviceManager.this.getDevice(deviceId);
            if (device == null) {
                DeviceManager.this.log.trace("Device not found: {}", (Object)deviceId);
            }
            DefaultPortDescription newPortDescription = new DefaultPortDescription(basePortDescription.portNumber(), basePortDescription.isEnabled(), true, basePortDescription.type(), basePortDescription.portSpeed(), new SparseAnnotations[]{basePortDescription.annotations()});
            DeviceEvent event = DeviceManager.this.store.updatePortStatus(((DeviceProvider)this.provider()).id(), deviceId, (PortDescription)newPortDescription);
            if (event != null) {
                DeviceManager.this.log.info("Device {} port {} status changed", (Object)deviceId, (Object)event.port().number());
                DeviceManager.this.post((Event)event);
            }
        }

        public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            DeviceManager.this.log.debug("got reply to a role request for {}: asked for {}, and got {}", new Object[]{deviceId, requested, response});
            if (requested == null && response == null) {
                DeviceManager.this.log.warn("Failed to assert role onto Device {}", (Object)deviceId);
                DeviceManager.this.mastershipService.relinquishMastership(deviceId);
                return;
            }
            if (Objects.equals(requested, response)) {
                if (Objects.equals(requested, DeviceManager.this.mastershipService.getLocalRole(deviceId))) {
                    return;
                }
                DeviceManager.this.log.warn("Role mismatch on {}. set to {}, but store demands {}", new Object[]{deviceId, response, DeviceManager.this.mastershipService.getLocalRole(deviceId)});
                DeviceManager.this.backgroundService.execute(() -> DeviceManager.this.reassertRole(deviceId, DeviceManager.this.mastershipService.getLocalRole(deviceId)));
                return;
            }
            DeviceManager.this.log.warn("Failed to assert role [{}] onto Device {}", (Object)response, (Object)deviceId);
            if (response == MastershipRole.MASTER) {
                DeviceManager.this.mastershipService.relinquishMastership(deviceId);
            }
        }

        public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            Preconditions.checkNotNull((Object)deviceId, (Object)DeviceManager.DEVICE_ID_NULL);
            Preconditions.checkNotNull(portStatistics, (Object)"Port statistics list cannot be null");
            this.checkValidity();
            DeviceEvent event = DeviceManager.this.store.updatePortStatistics(((DeviceProvider)this.provider()).id(), deviceId, portStatistics);
            DeviceManager.this.post((Event)event);
        }
    }

    private class LocalStatus {
        boolean connected;
        DateTime dateTime;

        public LocalStatus(boolean b, DateTime now) {
            this.connected = b;
            this.dateTime = now;
        }
    }
}

