/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.config.basics.BasicElementConfig;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.impl.BasicElementOperator;

public final class BasicDeviceOperator
extends BasicElementOperator {
    private BasicDeviceOperator() {
    }

    public static DeviceDescription combine(BasicDeviceConfig cfg, DeviceDescription descr) {
        if (cfg == null || descr == null) {
            return descr;
        }
        Device.Type type = descr.type();
        if (cfg.type() != null && cfg.type() != type) {
            type = cfg.type();
        }
        String manufacturer = descr.manufacturer();
        if (cfg.manufacturer() != null && !cfg.manufacturer().equals(manufacturer)) {
            manufacturer = cfg.manufacturer();
        }
        String hwVersion = descr.hwVersion();
        if (cfg.hwVersion() != null && !cfg.hwVersion().equals(hwVersion)) {
            hwVersion = cfg.hwVersion();
        }
        String swVersion = descr.swVersion();
        if (cfg.swVersion() != null && !cfg.swVersion().equals(swVersion)) {
            swVersion = cfg.swVersion();
        }
        String serial = descr.serialNumber();
        if (cfg.serial() != null && !cfg.serial().equals(serial)) {
            serial = cfg.serial();
        }
        SparseAnnotations sa = BasicDeviceOperator.combine(cfg, descr.annotations());
        return new DefaultDeviceDescription(descr.deviceUri(), type, manufacturer, hwVersion, swVersion, serial, descr.chassisId(), descr.isDefaultAvailable(), new SparseAnnotations[]{sa});
    }

    public static SparseAnnotations combine(BasicDeviceConfig cfg, SparseAnnotations an) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        if (!Objects.equals(cfg.driver(), an.value("driver"))) {
            builder.set("driver", cfg.driver());
        }
        BasicDeviceOperator.combineElementAnnotations((BasicElementConfig)cfg, builder);
        if (cfg.managementAddress() != null) {
            builder.set("managementAddress", cfg.managementAddress());
        }
        return DefaultAnnotations.union((SparseAnnotations)an, (SparseAnnotations)builder.build());
    }

    public static DeviceDescription descriptionOf(Device device) {
        Preconditions.checkNotNull((Object)device, (Object)"Must supply non-null Device");
        return new DefaultDeviceDescription(device.id().uri(), device.type(), device.manufacturer(), device.hwVersion(), device.swVersion(), device.serialNumber(), device.chassisId(), new SparseAnnotations[]{(SparseAnnotations)device.annotations()});
    }
}

