/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.NetworkConfigStore;
import org.onosproject.net.config.NetworkConfigStoreDelegate;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class NetworkConfigManager
extends AbstractListenerManager<NetworkConfigEvent, NetworkConfigListener>
implements NetworkConfigRegistry,
NetworkConfigService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String NULL_FACTORY_MSG = "Factory cannot be null";
    private static final String NULL_SCLASS_MSG = "Subject class cannot be null";
    private static final String NULL_SCKEY_MSG = "Subject class key cannot be null";
    private static final String NULL_CCLASS_MSG = "Config class cannot be null";
    private static final String NULL_CKEY_MSG = "Config key cannot be null";
    private static final String NULL_SUBJECT_MSG = "Subject cannot be null";
    private static final String NULL_JSON_MSG = "JSON cannot be null";
    private final Map<ConfigKey, ConfigFactory> factories = Maps.newConcurrentMap();
    private final Map<String, SubjectFactory> subjectClasses = Maps.newConcurrentMap();
    private final Map<Class, SubjectFactory> subjectClassKeys = Maps.newConcurrentMap();
    private final Map<ConfigIdentifier, Class<? extends Config>> configClasses = Maps.newConcurrentMap();
    private final NetworkConfigStoreDelegate storeDelegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigStore store;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(NetworkConfigEvent.class, (EventSink)this.listenerRegistry);
        this.store.setDelegate((StoreDelegate)this.storeDelegate);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(NetworkConfigEvent.class);
        this.store.unsetDelegate((StoreDelegate)this.storeDelegate);
        this.log.info("Stopped");
    }

    public void registerConfigFactory(ConfigFactory configFactory) {
        Preconditions.checkNotNull((Object)configFactory, (Object)NULL_FACTORY_MSG);
        this.factories.put(NetworkConfigManager.key(configFactory), configFactory);
        this.configClasses.put(NetworkConfigManager.identifier(configFactory), configFactory.configClass());
        SubjectFactory subjectFactory = configFactory.subjectFactory();
        this.subjectClasses.putIfAbsent(subjectFactory.subjectClassKey(), subjectFactory);
        this.subjectClassKeys.putIfAbsent(subjectFactory.subjectClass(), subjectFactory);
        this.store.addConfigFactory(configFactory);
    }

    public void unregisterConfigFactory(ConfigFactory configFactory) {
        Preconditions.checkNotNull((Object)configFactory, (Object)NULL_FACTORY_MSG);
        this.factories.remove(NetworkConfigManager.key(configFactory));
        this.configClasses.remove(NetworkConfigManager.identifier(configFactory));
        this.store.removeConfigFactory(configFactory);
    }

    public Set<ConfigFactory> getConfigFactories() {
        return ImmutableSet.copyOf(this.factories.values());
    }

    public <S, C extends Config<S>> Set<ConfigFactory<S, C>> getConfigFactories(Class<S> subjectClass) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.factories.forEach((key, factory) -> {
            if (factory.subjectFactory().subjectClass().equals(subjectClass)) {
                builder.add(factory);
            }
        });
        return builder.build();
    }

    public <S, C extends Config<S>> ConfigFactory<S, C> getConfigFactory(Class<C> configClass) {
        Preconditions.checkNotNull(configClass, (Object)NULL_CCLASS_MSG);
        return this.store.getConfigFactory(configClass);
    }

    public Set<Class> getSubjectClasses() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.factories.forEach((k, v) -> builder.add((Object)k.subjectClass));
        return builder.build();
    }

    public SubjectFactory getSubjectFactory(String subjectClassKey) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        return this.subjectClasses.get(subjectClassKey);
    }

    public SubjectFactory getSubjectFactory(Class subjectClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        return this.subjectClassKeys.get(subjectClass);
    }

    public Class<? extends Config> getConfigClass(String subjectClassKey, String configKey) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        Preconditions.checkNotNull((Object)subjectClassKey, (Object)NULL_SCKEY_MSG);
        Preconditions.checkNotNull((Object)configKey, (Object)NULL_CKEY_MSG);
        return this.configClasses.get(new ConfigIdentifier(subjectClassKey, configKey));
    }

    public <S> Set<S> getSubjects(Class<S> subjectClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        Preconditions.checkNotNull(subjectClass, (Object)NULL_SCLASS_MSG);
        return this.store.getSubjects(subjectClass);
    }

    public <S, C extends Config<S>> Set<S> getSubjects(Class<S> subjectClass, Class<C> configClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        Preconditions.checkNotNull(subjectClass, (Object)NULL_SCLASS_MSG);
        Preconditions.checkNotNull(configClass, (Object)NULL_CCLASS_MSG);
        return this.store.getSubjects(subjectClass, configClass);
    }

    public <S> Set<Config<S>> getConfigs(S subject) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Set configClasses = this.store.getConfigClasses(subject);
        ImmutableSet.Builder cfg = ImmutableSet.builder();
        configClasses.forEach(cc -> cfg.add((Object)this.store.getConfig(subject, cc)));
        return cfg.build();
    }

    public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Preconditions.checkNotNull(configClass, (Object)NULL_CCLASS_MSG);
        return (C)this.store.getConfig(subject, configClass);
    }

    public <S, C extends Config<S>> C addConfig(S subject, Class<C> configClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Preconditions.checkNotNull(configClass, (Object)NULL_CCLASS_MSG);
        return (C)this.store.createConfig(subject, configClass);
    }

    public <S, C extends Config<S>> C applyConfig(S subject, Class<C> configClass, JsonNode json) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Preconditions.checkNotNull(configClass, (Object)NULL_CCLASS_MSG);
        Preconditions.checkNotNull((Object)json, (Object)NULL_JSON_MSG);
        return (C)this.store.applyConfig(subject, configClass, json);
    }

    public <S, C extends Config<S>> C applyConfig(String subjectClassKey, S subject, String configKey, JsonNode json) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull((Object)subjectClassKey, (Object)NULL_SCKEY_MSG);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Preconditions.checkNotNull((Object)configKey, (Object)NULL_CKEY_MSG);
        Preconditions.checkNotNull((Object)json, (Object)NULL_JSON_MSG);
        Class<? extends Config> configClass = this.configClasses.get(new ConfigIdentifier(subjectClassKey, configKey));
        if (configClass != null) {
            return (C)this.store.applyConfig(subject, configClass, json);
        }
        this.log.info("Configuration '{}' queued for subject {}", (Object)configKey, subject);
        this.store.queueConfig(subject, configKey, json);
        return null;
    }

    public <S, C extends Config<S>> void removeConfig(S subject, Class<C> configClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Preconditions.checkNotNull(configClass, (Object)NULL_CCLASS_MSG);
        this.store.clearConfig(subject, configClass);
    }

    public <S> void removeConfig(String subjectClassKey, S subject, String configKey) {
        Preconditions.checkNotNull((Object)subjectClassKey, (Object)NULL_SCKEY_MSG);
        Preconditions.checkNotNull(subject, (Object)NULL_SUBJECT_MSG);
        Preconditions.checkNotNull((Object)configKey, (Object)NULL_CKEY_MSG);
        Class<? extends Config> configClass = this.configClasses.get(new ConfigIdentifier(subjectClassKey, configKey));
        if (configClass != null) {
            this.store.clearConfig(subject, configClass);
        } else {
            this.store.clearQueuedConfig(subject, configKey);
        }
    }

    public <S> void removeConfig(S subject) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        this.store.clearConfig(subject);
    }

    public <S> void removeConfig() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        this.store.clearConfig();
    }

    private static ConfigKey key(ConfigFactory factory) {
        return new ConfigKey(factory.subjectFactory().subjectClass(), factory.configClass());
    }

    private static ConfigIdentifier identifier(ConfigFactory factory) {
        return new ConfigIdentifier(factory.subjectFactory().subjectClassKey(), factory.configKey());
    }

    protected void bindStore(NetworkConfigStore networkConfigStore) {
        this.store = networkConfigStore;
    }

    protected void unbindStore(NetworkConfigStore networkConfigStore) {
        if (this.store == networkConfigStore) {
            this.store = null;
        }
    }

    static final class ConfigIdentifier {
        final String subjectClassKey;
        final String configKey;

        protected ConfigIdentifier(String subjectClassKey, String configKey) {
            this.subjectClassKey = subjectClassKey;
            this.configKey = configKey;
        }

        public int hashCode() {
            return Objects.hash(this.subjectClassKey, this.configKey);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConfigIdentifier) {
                ConfigIdentifier other = (ConfigIdentifier)obj;
                return Objects.equals(this.subjectClassKey, other.subjectClassKey) && Objects.equals(this.configKey, other.configKey);
            }
            return false;
        }
    }

    protected static final class ConfigKey {
        final Class subjectClass;
        final Class configClass;

        protected ConfigKey(Class subjectClass, Class configClass) {
            this.subjectClass = subjectClass;
            this.configClass = configClass;
        }

        public int hashCode() {
            return Objects.hash(this.subjectClass, this.configClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConfigKey) {
                ConfigKey other = (ConfigKey)obj;
                return Objects.equals(this.subjectClass, other.subjectClass) && Objects.equals(this.configClass, other.configClass);
            }
            return false;
        }
    }

    private class InternalStoreDelegate
    implements NetworkConfigStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(NetworkConfigEvent event) {
            NetworkConfigManager.this.post((Event)event);
        }
    }
}

