/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.EventListener;
import org.onosproject.net.config.BasicNetworkConfigService;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetworkConfigLoader {
    private static final File CFG_FILE = new File("../config/network-cfg.json");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected BasicNetworkConfigService basicConfigs;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    private final Map<InnerConfigPosition, JsonNode> jsons = Maps.newConcurrentMap();
    private final NetworkConfigListener configListener = new InnerConfigListener();
    private ObjectNode root;

    @Activate
    public void activate() {
        this.networkConfigService.addListener((EventListener)this.configListener);
        try {
            if (CFG_FILE.exists()) {
                this.root = (ObjectNode)new ObjectMapper().readTree(CFG_FILE);
                this.populateConfigurations();
                if (this.applyConfigurations()) {
                    this.log.info("Loaded initial network configuration from {}", (Object)CFG_FILE);
                } else {
                    this.log.error("Partially loaded initial network configuration from {}", (Object)CFG_FILE);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to load initial network configuration from {}", (Object)CFG_FILE, (Object)e);
        }
    }

    @Deactivate
    public void deactivate() {
        this.networkConfigService.removeListener((EventListener)this.configListener);
    }

    private void saveJson(String sk, ObjectNode node) {
        node.fieldNames().forEachRemaining(s -> this.saveSubjectJson(sk, (String)s, (ObjectNode)node.path(s)));
    }

    private void saveSubjectJson(String sk, String s, ObjectNode node) {
        node.fieldNames().forEachRemaining(c -> this.jsons.put(new InnerConfigPosition(sk, s, (String)c), node.path(c)));
    }

    private void populateConfigurations() {
        this.root.fieldNames().forEachRemaining(sk -> this.saveJson((String)sk, (ObjectNode)this.root.path(sk)));
    }

    private boolean applyConfigurations() {
        Iterator<Map.Entry<InnerConfigPosition, JsonNode>> iter = this.jsons.entrySet().iterator();
        boolean isSuccess = true;
        while (iter.hasNext()) {
            Map.Entry<InnerConfigPosition, JsonNode> entry = iter.next();
            JsonNode node = entry.getValue();
            InnerConfigPosition key = entry.getKey();
            String subjectKey = key.subjectKey();
            String subjectString = key.subject();
            String configKey = key.configKey();
            Class configClass = this.networkConfigService.getConfigClass(subjectKey, configKey);
            if (configClass == null) continue;
            Object subject = this.networkConfigService.getSubjectFactory(subjectKey).createSubject(subjectString);
            try {
                this.networkConfigService.applyConfig(subject, configClass, node);
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Error parsing config " + subjectKey + "/" + subject + "/" + configKey);
                isSuccess = false;
            }
            iter.remove();
        }
        return isSuccess;
    }

    protected void bindBasicConfigs(BasicNetworkConfigService basicNetworkConfigService) {
        this.basicConfigs = basicNetworkConfigService;
    }

    protected void unbindBasicConfigs(BasicNetworkConfigService basicNetworkConfigService) {
        if (this.basicConfigs == basicNetworkConfigService) {
            this.basicConfigs = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    private final class InnerConfigPosition {
        private final String subjectKey;
        private final String subject;
        private final String configKey;

        private String subjectKey() {
            return this.subjectKey;
        }

        private String subject() {
            return this.subject;
        }

        private String configKey() {
            return this.configKey;
        }

        private InnerConfigPosition(String subjectKey, String subject, String configKey) {
            this.subjectKey = subjectKey;
            this.subject = subject;
            this.configKey = configKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof InnerConfigPosition) {
                InnerConfigPosition that = (InnerConfigPosition)obj;
                return Objects.equals(this.subjectKey, that.subjectKey) && Objects.equals(this.subject, that.subject) && Objects.equals(this.configKey, that.configKey);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.subjectKey, this.subject, this.configKey);
        }
    }

    private final class InnerConfigListener
    implements NetworkConfigListener {
        private InnerConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.type() == NetworkConfigEvent.Type.CONFIG_REGISTERED || event.type() == NetworkConfigEvent.Type.CONFIG_ADDED) {
                NetworkConfigLoader.this.applyConfigurations();
            }
        }
    }
}

