/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ChassisId;
import org.onlab.util.Tools;
import org.onosproject.event.EventListener;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.config.inject.DeviceInjectionConfig;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Service(value={DeviceInjectionConfigMonitor.class})
@Component(immediate=true)
public class DeviceInjectionConfigMonitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ProviderId pid = new ProviderId("inject", "org.onosproject.inject");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netcfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netcfgRegistry;
    private final List<ConfigFactory<?, ?>> factories = ImmutableList.of((Object)new ConfigFactory<DeviceId, DeviceInjectionConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, DeviceInjectionConfig.class, "inject"){

        public DeviceInjectionConfig createConfig() {
            return new DeviceInjectionConfig();
        }
    });
    private final InternalConfigListener listener = new InternalConfigListener();
    private ExecutorService worker;
    private InternalDeviceProvider deviceProvider = new InternalDeviceProvider();
    private DeviceProviderService providerService;

    @Activate
    public void activate() {
        this.worker = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/inject", (String)"worker", (Logger)this.log));
        this.providerService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this.deviceProvider);
        this.netcfgService.addListener((EventListener)this.listener);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.netcfgRegistry).registerConfigFactory(arg_0));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.netcfgService.removeListener((EventListener)this.listener);
        this.deviceProviderRegistry.unregister((Provider)this.deviceProvider);
        this.worker.shutdown();
        try {
            this.worker.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.netcfgRegistry).unregisterConfigFactory(arg_0));
        this.log.info("Stopped");
    }

    private void removeDevice(DeviceId did) {
        this.providerService.deviceDisconnected(did);
    }

    private void injectDevice(DeviceId did) {
        Optional<Config> basic = Optional.ofNullable(this.netcfgService.getConfig((Object)did, BasicDeviceConfig.class));
        Optional<DeviceDescriptionDiscovery> discovery = basic.map(BasicDeviceConfig::driver).map(arg_0 -> ((DriverService)this.driverService).getDriver(arg_0)).filter(drvr -> drvr.hasBehaviour(DeviceDescriptionDiscovery.class)).map(drvr -> (DeviceDescriptionDiscovery)drvr.createBehaviour((DriverHandler)new DefaultDriverHandler((DriverData)new DefaultDriverData(drvr, did)), DeviceDescriptionDiscovery.class));
        if (discovery.isPresent()) {
            this.providerService.deviceConnected(did, discovery.get().discoverDeviceDetails());
            this.providerService.updatePorts(did, discovery.get().discoverPortDetails());
        } else {
            String unk = "UNKNOWN";
            DefaultDeviceDescription desc = new DefaultDeviceDescription(did.uri(), basic.map(BasicDeviceConfig::type).orElse(Device.Type.SWITCH), basic.map(BasicDeviceConfig::manufacturer).orElse(unk), basic.map(BasicDeviceConfig::hwVersion).orElse(unk), basic.map(BasicDeviceConfig::swVersion).orElse(unk), basic.map(BasicDeviceConfig::serial).orElse(unk), new ChassisId(), true, new SparseAnnotations[0]);
            this.providerService.deviceConnected(did, (DeviceDescription)desc);
            Optional<Config> inject = Optional.ofNullable(this.netcfgService.getConfig((Object)did, DeviceInjectionConfig.class));
            String ports = inject.map(DeviceInjectionConfig::ports).orElse("0");
            int numPorts = Integer.parseInt(ports);
            ArrayList<DefaultPortDescription> portDescs = new ArrayList<DefaultPortDescription>(numPorts);
            for (int i = 1; i <= numPorts; ++i) {
                PortNumber number = PortNumber.portNumber((long)i);
                boolean isEnabled = true;
                portDescs.add(new DefaultPortDescription(number, isEnabled, new SparseAnnotations[0]));
            }
            this.providerService.updatePorts(did, portDescs);
        }
    }

    protected void bindNetcfgService(NetworkConfigService networkConfigService) {
        this.netcfgService = networkConfigService;
    }

    protected void unbindNetcfgService(NetworkConfigService networkConfigService) {
        if (this.netcfgService == networkConfigService) {
            this.netcfgService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindNetcfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.netcfgRegistry = networkConfigRegistry;
    }

    protected void unbindNetcfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netcfgRegistry == networkConfigRegistry) {
            this.netcfgRegistry = null;
        }
    }

    final class InternalConfigListener
    implements NetworkConfigListener {
        private final Set<NetworkConfigEvent.Type> relevant = ImmutableSet.copyOf(EnumSet.of(NetworkConfigEvent.Type.CONFIG_ADDED, NetworkConfigEvent.Type.CONFIG_UPDATED, NetworkConfigEvent.Type.CONFIG_REMOVED));

        InternalConfigListener() {
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return event.configClass() == DeviceInjectionConfig.class && this.relevant.contains(event.type());
        }

        public void event(NetworkConfigEvent event) {
            DeviceInjectionConfigMonitor.this.worker.execute(() -> this.processEvent(event));
        }

        protected void processEvent(NetworkConfigEvent event) {
            DeviceId did = (DeviceId)event.subject();
            if (!did.uri().getScheme().equals(DeviceInjectionConfigMonitor.this.pid.scheme())) {
                DeviceInjectionConfigMonitor.this.log.warn("Attempt to inject unexpected scheme {}", (Object)did);
                return;
            }
            DeviceInjectionConfigMonitor.this.log.debug("{} to {}: {}", new Object[]{event.type(), did, event});
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: {
                    DeviceInjectionConfigMonitor.this.injectDevice(did);
                    break;
                }
                case CONFIG_REMOVED: {
                    DeviceInjectionConfigMonitor.this.removeDevice(did);
                    break;
                }
                default: {
                    DeviceInjectionConfigMonitor.this.log.warn("Ignoring unexpected event: {}", (Object)event);
                }
            }
        }
    }

    final class InternalDeviceProvider
    implements DeviceProvider {
        InternalDeviceProvider() {
        }

        public ProviderId id() {
            return DeviceInjectionConfigMonitor.this.pid;
        }

        public void triggerProbe(DeviceId deviceId) {
            DeviceInjectionConfigMonitor.this.worker.execute(() -> DeviceInjectionConfigMonitor.this.injectDevice(deviceId));
        }

        public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
            DeviceInjectionConfigMonitor.this.providerService.receivedRoleReply(deviceId, newRole, newRole);
        }

        public boolean isReachable(DeviceId deviceId) {
            return true;
        }

        public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        }
    }
}

