/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.config.basics.InterfaceConfig;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.BasicNetworkConfigService;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.config.basics.BasicHostConfig;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.config.basics.BasicRegionConfig;
import org.onosproject.net.config.basics.BasicUiTopoLayoutConfig;
import org.onosproject.net.config.basics.PortAnnotationConfig;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiTopoLayoutId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class BasicNetworkConfigs
implements BasicNetworkConfigService {
    private static final String BASIC = "basic";
    private static final String INTERFACES = "interfaces";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<ConfigFactory> factories = ImmutableSet.of((Object)new ConfigFactory<DeviceId, BasicDeviceConfig>(SubjectFactories.DEVICE_SUBJECT_FACTORY, BasicDeviceConfig.class, "basic"){

        public BasicDeviceConfig createConfig() {
            return new BasicDeviceConfig();
        }
    }, (Object)new ConfigFactory<ConnectPoint, InterfaceConfig>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, InterfaceConfig.class, "interfaces", true){

        public InterfaceConfig createConfig() {
            return new InterfaceConfig();
        }
    }, (Object)new ConfigFactory<HostId, BasicHostConfig>(SubjectFactories.HOST_SUBJECT_FACTORY, BasicHostConfig.class, "basic"){

        public BasicHostConfig createConfig() {
            return new BasicHostConfig();
        }
    }, (Object)new ConfigFactory<LinkKey, BasicLinkConfig>(SubjectFactories.LINK_SUBJECT_FACTORY, BasicLinkConfig.class, "basic"){

        public BasicLinkConfig createConfig() {
            return new BasicLinkConfig();
        }
    }, (Object)new ConfigFactory<RegionId, BasicRegionConfig>(SubjectFactories.REGION_SUBJECT_FACTORY, BasicRegionConfig.class, "basic"){

        public BasicRegionConfig createConfig() {
            return new BasicRegionConfig();
        }
    }, (Object)new ConfigFactory<UiTopoLayoutId, BasicUiTopoLayoutConfig>(SubjectFactories.LAYOUT_SUBJECT_FACTORY, BasicUiTopoLayoutConfig.class, "basic"){

        public BasicUiTopoLayoutConfig createConfig() {
            return new BasicUiTopoLayoutConfig();
        }
    }, (Object[])new ConfigFactory[]{new ConfigFactory<ConnectPoint, PortAnnotationConfig>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, PortAnnotationConfig.class, "annotations"){

        public PortAnnotationConfig createConfig() {
            return new PortAnnotationConfig();
        }
    }});
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry registry;

    @Activate
    public void activate() {
        SubjectFactories.setCoreService((CoreService)this.coreService);
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.registry).registerConfigFactory(arg_0));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.factories.forEach(arg_0 -> ((NetworkConfigRegistry)this.registry).unregisterConfigFactory(arg_0));
        this.log.info("Stopped");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.registry = networkConfigRegistry;
    }

    protected void unbindRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.registry == networkConfigRegistry) {
            this.registry = null;
        }
    }
}

