/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.SharedExecutors;
import org.onlab.util.Tools;
import org.onosproject.event.AbstractEvent;
import org.onosproject.event.DefaultEventSinkRegistry;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventSink;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class CoreEventDispatcher
extends DefaultEventSinkRegistry
implements EventDeliveryService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DispatchLoop topologyDispatcher = new DispatchLoop("topology");
    private DispatchLoop programmingDispatcher = new DispatchLoop("programming");
    private DispatchLoop defaultDispatcher = new DispatchLoop("default");
    private Map<Class, DispatchLoop> dispatcherMap = new ImmutableMap.Builder().put(TopologyEvent.class, (Object)this.topologyDispatcher).put(DeviceEvent.class, (Object)this.topologyDispatcher).put(LinkEvent.class, (Object)this.topologyDispatcher).put(HostEvent.class, (Object)this.topologyDispatcher).put(FlowRuleEvent.class, (Object)this.programmingDispatcher).put(IntentEvent.class, (Object)this.programmingDispatcher).build();
    private Set<DispatchLoop> dispatchers = new ImmutableSet.Builder().addAll(this.dispatcherMap.values()).add((Object)this.defaultDispatcher).build();
    private static final long DEFAULT_EXECUTE_MS = 5000L;
    private static final long WATCHDOG_MS = 250L;
    private static final Event KILL_PILL = new AbstractEvent(null, 0){};
    private long maxProcessMillis = 5000L;

    private DispatchLoop getDispatcher(Event event) {
        DispatchLoop dispatcher = this.dispatcherMap.get(event.getClass());
        if (dispatcher == null) {
            dispatcher = this.defaultDispatcher;
        }
        return dispatcher;
    }

    public void post(Event event) {
        if (!this.getDispatcher(event).add(event)) {
            this.log.error("Unable to post event {}", (Object)event);
        }
    }

    @Activate
    public void activate() {
        if (this.maxProcessMillis != 0L) {
            this.dispatchers.forEach(rec$ -> ((DispatchLoop)rec$).startWatchdog());
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.dispatchers.forEach(DispatchLoop::stop);
        this.log.info("Stopped");
    }

    public void setDispatchTimeLimit(long millis) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.EVENT_WRITE);
        Preconditions.checkArgument((millis == 0L || millis >= 250L ? 1 : 0) != 0, (String)"Time limit must be greater than %s", (long)250L);
        long oldMillis = this.maxProcessMillis;
        this.maxProcessMillis = millis;
        if (millis == 0L && oldMillis != 0L) {
            this.dispatchers.forEach(rec$ -> ((DispatchLoop)rec$).stopWatchdog());
        } else if (millis != 0L && oldMillis == 0L) {
            this.dispatchers.forEach(rec$ -> ((DispatchLoop)rec$).startWatchdog());
        }
    }

    public long getDispatchTimeLimit() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.EVENT_READ);
        return this.maxProcessMillis;
    }

    private class DispatchLoop
    implements Runnable {
        private final String name;
        private volatile boolean stopped;
        private volatile EventSink lastSink;
        private final Stopwatch stopwatch = Stopwatch.createUnstarted();
        private TimerTask watchdog;
        private volatile Future<?> dispatchFuture;
        private final BlockingQueue<Event> eventsQueue;
        private final ExecutorService executor;

        DispatchLoop(String name) {
            this.name = name;
            this.executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/event", (String)("dispatch-" + name + "%d"), (Logger)CoreEventDispatcher.this.log));
            this.eventsQueue = new LinkedBlockingQueue<Event>();
            this.dispatchFuture = this.executor.submit(this);
        }

        public boolean add(Event event) {
            return this.eventsQueue.add(event);
        }

        @Override
        public void run() {
            this.stopped = false;
            CoreEventDispatcher.this.log.info("Dispatch loop initiated");
            while (!this.stopped) {
                try {
                    Event event = this.eventsQueue.take();
                    if (event == KILL_PILL) break;
                    this.process(event);
                }
                catch (InterruptedException e) {
                    CoreEventDispatcher.this.log.warn("Dispatch loop interrupted");
                }
                catch (Error | Exception e) {
                    CoreEventDispatcher.this.log.warn("Error encountered while dispatching event:", e);
                }
            }
            CoreEventDispatcher.this.log.info("Dispatch loop terminated");
        }

        private void process(Event event) {
            EventSink sink = CoreEventDispatcher.this.getSink(event.getClass());
            if (sink != null) {
                this.lastSink = sink;
                this.stopwatch.start();
                sink.process(event);
                this.stopwatch.reset();
            } else {
                CoreEventDispatcher.this.log.warn("No sink registered for event class {}", (Object)event.getClass().getName());
            }
        }

        void stop() {
            this.stopped = true;
            this.stopWatchdog();
            this.add(KILL_PILL);
        }

        private void startWatchdog() {
            CoreEventDispatcher.this.log.info("Starting watchdog task for dispatcher {}", (Object)this.name);
            this.watchdog = new Watchdog();
            SharedExecutors.getTimer().schedule(this.watchdog, 250L, 250L);
        }

        private void stopWatchdog() {
            CoreEventDispatcher.this.log.info("Stopping watchdog task for dispatcher {}", (Object)this.name);
            if (this.watchdog != null) {
                this.watchdog.cancel();
            }
        }

        private class Watchdog
        extends TimerTask {
            private Watchdog() {
            }

            @Override
            public void run() {
                long elapsedTimeMillis = DispatchLoop.this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (elapsedTimeMillis > CoreEventDispatcher.this.maxProcessMillis) {
                    DispatchLoop.this.stopwatch.reset();
                    CoreEventDispatcher.this.log.warn("Event sink {} exceeded execution time limit: {} ms; spawning new dispatch loop", (Object)DispatchLoop.this.lastSink.getClass().getName(), (Object)elapsedTimeMillis);
                    DispatchLoop.this.lastSink.onProcessLimit();
                    DispatchLoop.this.stop();
                    DispatchLoop.this.dispatchFuture.cancel(true);
                    DispatchLoop.this.dispatchFuture = DispatchLoop.this.executor.submit(this);
                }
            }
        }
    }
}

