/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core.impl;

import java.util.function.Supplier;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.HybridLogicalClockService;
import org.onosproject.core.HybridLogicalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class HybridLogicalClockManager
implements HybridLogicalClockService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Supplier<Long> physicalTimeSource = System::currentTimeMillis;
    private long logicalTime = 0L;
    private long logicalCounter = 0L;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public synchronized HybridLogicalTime timeNow() {
        long oldLogicalTime = this.logicalTime;
        this.logicalTime = Math.max(oldLogicalTime, this.physicalTimeSource.get());
        this.logicalCounter = this.logicalTime == oldLogicalTime ? ++this.logicalCounter : 0L;
        return new HybridLogicalTime(this.logicalTime, this.logicalCounter);
    }

    public synchronized void recordEventTime(HybridLogicalTime eTime) {
        long oldLogicalTime = this.logicalTime;
        this.logicalTime = Math.max(oldLogicalTime, Math.max(eTime.logicalTime(), this.physicalTimeSource.get()));
        this.logicalCounter = this.logicalTime == oldLogicalTime && oldLogicalTime == eTime.logicalTime() ? Math.max(this.logicalCounter, eTime.logicalCounter()) + 1L : (this.logicalTime == oldLogicalTime ? ++this.logicalCounter : (this.logicalTime == eTime.logicalTime() ? eTime.logicalCounter() + 1L : 0L));
    }

    protected long logicalTime() {
        return this.logicalTime;
    }

    protected long logicalCounter() {
        return this.logicalCounter;
    }
}

