/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.MetricsService;
import org.onlab.util.SharedExecutors;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationIdStore;
import org.onosproject.app.ApplicationService;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdBlockStore;
import org.onosproject.core.IdGenerator;
import org.onosproject.core.Version;
import org.onosproject.core.impl.BlockAllocatorBasedIdGenerator;
import org.onosproject.core.impl.StoreBasedIdBlockAllocator;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class CoreManager
implements CoreService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final File VERSION_FILE = new File("../VERSION");
    private static Version version = Version.version((String)"1.10.4");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationIdStore applicationIdStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IdBlockStore idBlockStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationService appService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDeliveryService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private static final int DEFAULT_POOL_SIZE = 30;
    @Property(name="sharedThreadPoolSize", intValue={30}, label="Configure shared pool maximum size ")
    private int sharedThreadPoolSize = 30;
    private static final int DEFAULT_EVENT_TIME = 2000;
    @Property(name="maxEventTimeLimit", intValue={2000}, label="Maximum number of millis an event sink has to process an event")
    private int maxEventTimeLimit = 2000;
    private static final boolean DEFAULT_PERFORMANCE_CHECK = false;
    @Property(name="sharedThreadPerformanceCheck", boolValue={false}, label="Enable queue performance check on shared pool")
    private boolean calculatePoolPerformance = false;

    @Activate
    protected void activate() {
        this.registerApplication("org.onosproject.core");
        this.cfgService.registerProperties(this.getClass());
        try {
            Path path = Paths.get(VERSION_FILE.getPath(), new String[0]);
            List<String> versionLines = Files.readAllLines(path);
            if (versionLines != null && !versionLines.isEmpty()) {
                version = Version.version((String)versionLines.get(0));
            }
        }
        catch (IOException e) {
            this.log.trace("Version file not found", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        SharedExecutors.shutdown();
    }

    public Version version() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        return version;
    }

    public Set<ApplicationId> getAppIds() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        return this.applicationIdStore.getAppIds();
    }

    public ApplicationId getAppId(Short id) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        return this.applicationIdStore.getAppId(id);
    }

    public ApplicationId getAppId(String name) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        return this.applicationIdStore.getAppId(name);
    }

    public ApplicationId registerApplication(String name) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_WRITE);
        Preconditions.checkNotNull((Object)name, (Object)"Application ID cannot be null");
        return this.applicationIdStore.registerApplication(name);
    }

    public ApplicationId registerApplication(String name, Runnable preDeactivate) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_WRITE);
        ApplicationId id = this.registerApplication(name);
        this.appService.registerDeactivateHook(id, preDeactivate);
        return id;
    }

    public IdGenerator getIdGenerator(String topic) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        StoreBasedIdBlockAllocator allocator = new StoreBasedIdBlockAllocator(topic, this.idBlockStore);
        return new BlockAllocatorBasedIdGenerator(allocator);
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Integer poolSize = Tools.getIntegerProperty((Dictionary)properties, (String)"sharedThreadPoolSize");
        if (poolSize != null && poolSize > 1) {
            this.sharedThreadPoolSize = poolSize;
            SharedExecutors.setPoolSize((int)this.sharedThreadPoolSize);
        } else if (poolSize != null) {
            this.log.warn("sharedThreadPoolSize must be greater than 1");
        }
        Integer timeLimit = Tools.getIntegerProperty((Dictionary)properties, (String)"maxEventTimeLimit");
        if (timeLimit != null && timeLimit >= 0) {
            this.maxEventTimeLimit = timeLimit;
            this.eventDeliveryService.setDispatchTimeLimit((long)this.maxEventTimeLimit);
        } else if (timeLimit != null) {
            this.log.warn("maxEventTimeLimit must be greater than or equal to 0");
        }
        Boolean performanceCheck = Tools.isPropertyEnabled((Dictionary)properties, (String)"sharedThreadPerformanceCheck");
        if (performanceCheck != null) {
            this.calculatePoolPerformance = performanceCheck;
            SharedExecutors.setMetricsService((MetricsService)(this.calculatePoolPerformance ? this.metricsService : null));
        }
        this.log.info("Settings: sharedThreadPoolSize={}, maxEventTimeLimit={}, calculatePoolPerformance={}", new Object[]{this.sharedThreadPoolSize, this.maxEventTimeLimit, this.calculatePoolPerformance});
    }

    protected void bindApplicationIdStore(ApplicationIdStore applicationIdStore) {
        this.applicationIdStore = applicationIdStore;
    }

    protected void unbindApplicationIdStore(ApplicationIdStore applicationIdStore) {
        if (this.applicationIdStore == applicationIdStore) {
            this.applicationIdStore = null;
        }
    }

    protected void bindIdBlockStore(IdBlockStore idBlockStore) {
        this.idBlockStore = idBlockStore;
    }

    protected void unbindIdBlockStore(IdBlockStore idBlockStore) {
        if (this.idBlockStore == idBlockStore) {
            this.idBlockStore = null;
        }
    }

    protected void bindAppService(ApplicationService applicationService) {
        this.appService = applicationService;
    }

    protected void unbindAppService(ApplicationService applicationService) {
        if (this.appService == applicationService) {
            this.appService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindEventDeliveryService(EventDeliveryService eventDeliveryService) {
        this.eventDeliveryService = eventDeliveryService;
    }

    protected void unbindEventDeliveryService(EventDeliveryService eventDeliveryService) {
        if (this.eventDeliveryService == eventDeliveryService) {
            this.eventDeliveryService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }
}

