/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.core.IdBlock;
import org.onosproject.core.IdGenerator;
import org.onosproject.core.UnavailableIdException;
import org.onosproject.core.impl.IdBlockAllocator;

public class BlockAllocatorBasedIdGenerator
implements IdGenerator {
    protected final IdBlockAllocator allocator;
    protected IdBlock idBlock;
    protected AtomicBoolean initialized;

    protected BlockAllocatorBasedIdGenerator(IdBlockAllocator allocator) {
        this.allocator = (IdBlockAllocator)Preconditions.checkNotNull((Object)allocator, (Object)"allocator cannot be null");
        this.initialized = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNewId() {
        try {
            if (!this.initialized.get()) {
                IdBlockAllocator idBlockAllocator = this.allocator;
                synchronized (idBlockAllocator) {
                    if (!this.initialized.get()) {
                        this.idBlock = this.allocator.allocateUniqueIdBlock();
                        this.initialized.set(true);
                    }
                }
            }
            return this.idBlock.getNextId();
        }
        catch (UnavailableIdException e) {
            IdBlockAllocator idBlockAllocator = this.allocator;
            synchronized (idBlockAllocator) {
                this.idBlock = this.allocator.allocateUniqueIdBlock();
            }
            return this.idBlock.getNextId();
        }
    }
}

