/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.MetricsService;
import org.onlab.metrics.MetricsUtil;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cfg.ConfigProperty;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.core.MetricsHelper;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipStore;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class MastershipManager
extends AbstractListenerManager<MastershipEvent, MastershipListener>
implements MastershipService,
MastershipAdminService,
MastershipTermService,
MetricsHelper {
    private static final String NODE_ID_NULL = "Node ID cannot be null";
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String ROLE_NULL = "Mastership role cannot be null";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final MastershipStoreDelegate delegate = new InternalDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RegionService regionService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private NodeId localNodeId;
    private Timer requestRoleTimer;
    static final boolean DEFAULT_USE_REGION_FOR_BALANCE_ROLES = false;
    @Property(name="useRegionForBalanceRoles", boolValue={false}, label="Use Regions for balancing roles")
    public boolean useRegionForBalanceRoles;

    @Activate
    public void activate() {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.modified();
        this.requestRoleTimer = this.createTimer("Mastership", "requestRole", "responseTime");
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.eventDispatcher.addSink(MastershipEvent.class, (EventSink)this.listenerRegistry);
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Modified
    public void modified() {
        Set configProperties = this.cfgService.getProperties(((Object)((Object)this)).getClass().getCanonicalName());
        for (ConfigProperty property : configProperties) {
            if (!"useRegionForBalanceRoles".equals(property.name())) continue;
            this.useRegionForBalanceRoles = property.asBoolean();
        }
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(MastershipEvent.class);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.log.info("Stopped");
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
    }

    public CompletableFuture<Void> setRole(NodeId nodeId, DeviceId deviceId, MastershipRole role) {
        Preconditions.checkNotNull((Object)nodeId, (Object)NODE_ID_NULL);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)role, (Object)ROLE_NULL);
        CompletableFuture eventFuture = null;
        switch (role) {
            case MASTER: {
                eventFuture = this.store.setMaster(nodeId, deviceId);
                break;
            }
            case STANDBY: {
                eventFuture = this.store.setStandby(nodeId, deviceId);
                break;
            }
            case NONE: {
                eventFuture = this.store.relinquishRole(nodeId, deviceId);
                break;
            }
            default: {
                this.log.info("Unknown role; ignoring");
                return CompletableFuture.completedFuture(null);
            }
        }
        return ((CompletableFuture)eventFuture.thenAccept(arg_0 -> ((MastershipManager)this).post(arg_0))).thenApply(v -> null);
    }

    public MastershipRole getLocalRole(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getRole(this.clusterService.getLocalNode().id(), deviceId);
    }

    public CompletableFuture<Void> relinquishMastership(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_WRITE);
        return ((CompletableFuture)this.store.relinquishRole(this.localNodeId, deviceId).thenAccept(arg_0 -> ((MastershipManager)this).post(arg_0))).thenApply(v -> null);
    }

    public CompletableFuture<MastershipRole> requestRoleFor(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_WRITE);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.requestRoleTimer);
        return this.store.requestRole(deviceId).whenComplete((result, error) -> MetricsUtil.stopTimer((Timer.Context)timer));
    }

    public NodeId getMasterFor(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getMaster(deviceId);
    }

    public Set<DeviceId> getDevicesOf(NodeId nodeId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Preconditions.checkNotNull((Object)nodeId, (Object)NODE_ID_NULL);
        return this.store.getDevices(nodeId);
    }

    public RoleInfo getNodesFor(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        return this.store.getNodes(deviceId);
    }

    public MastershipTerm getMastershipTerm(DeviceId deviceId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        return this.store.getTermFor(deviceId);
    }

    public MetricsService metricsService() {
        return this.metricsService;
    }

    public void balanceRoles() {
        ArrayList nodes = Lists.newArrayList((Iterable)this.clusterService.getNodes());
        HashMap<ControllerNode, Set<DeviceId>> controllerDevices = new HashMap<ControllerNode, Set<DeviceId>>();
        int deviceCount = 0;
        for (ControllerNode node : nodes) {
            if (!this.clusterService.getState(node.id()).isActive()) continue;
            HashSet<DeviceId> devicesOf = new HashSet<DeviceId>(this.getDevicesOf(node.id()));
            deviceCount += devicesOf.size();
            controllerDevices.put(node, devicesOf);
            this.log.info("Node {} has {} devices.", (Object)node.id(), (Object)devicesOf.size());
        }
        if (this.useRegionForBalanceRoles && this.balanceRolesUsingRegions(controllerDevices)) {
            return;
        }
        List<CompletableFuture<Void>> balanceBucketsFutures = this.balanceControllerNodes(controllerDevices, deviceCount);
        CompletableFuture<Void> balanceRolesFuture = CompletableFuture.allOf(balanceBucketsFutures.toArray(new CompletableFuture[balanceBucketsFutures.size()]));
        Futures.getUnchecked(balanceRolesFuture);
    }

    private List<CompletableFuture<Void>> balanceControllerNodes(Map<ControllerNode, Set<DeviceId>> controllerDevices, int deviceCount) {
        LinkedList balanceBucketsFutures = Lists.newLinkedList();
        int rounds = controllerDevices.keySet().size();
        for (int i = 0; i < rounds; ++i) {
            ControllerNode smallest = this.findBucket(true, controllerDevices);
            ControllerNode largest = this.findBucket(false, controllerDevices);
            balanceBucketsFutures.add(this.balanceBuckets(smallest, largest, controllerDevices, deviceCount));
        }
        return balanceBucketsFutures;
    }

    private ControllerNode findBucket(boolean min, Map<ControllerNode, Set<DeviceId>> controllerDevices) {
        int xSize = min ? Integer.MAX_VALUE : -1;
        ControllerNode xNode = null;
        for (ControllerNode node : controllerDevices.keySet()) {
            int size = controllerDevices.get(node).size();
            if ((!min || size >= xSize) && (min || size <= xSize)) continue;
            xSize = size;
            xNode = node;
        }
        return xNode;
    }

    private CompletableFuture<Void> balanceBuckets(ControllerNode smallest, ControllerNode largest, Map<ControllerNode, Set<DeviceId>> controllerDevices, int deviceCount) {
        Collection minBucket = controllerDevices.get(smallest);
        Collection maxBucket = controllerDevices.get(largest);
        int bucketCount = controllerDevices.keySet().size();
        int delta = (maxBucket.size() - minBucket.size()) / 2;
        delta = Math.min(deviceCount / bucketCount, delta);
        LinkedList setRoleFutures = Lists.newLinkedList();
        if (delta > 0) {
            this.log.info("Attempting to move {} nodes from {} to {}...", new Object[]{delta, largest.id(), smallest.id()});
            Iterator it = maxBucket.iterator();
            for (int i = 0; it.hasNext() && i < delta; ++i) {
                DeviceId deviceId = (DeviceId)it.next();
                this.log.info("Setting {} as the master for {}", (Object)smallest.id(), (Object)deviceId);
                setRoleFutures.add(this.setRole(smallest.id(), deviceId, MastershipRole.MASTER));
                controllerDevices.get(smallest).add(deviceId);
                it.remove();
            }
        }
        return CompletableFuture.allOf(setRoleFutures.toArray(new CompletableFuture[setRoleFutures.size()]));
    }

    private boolean balanceRolesUsingRegions(Map<ControllerNode, Set<DeviceId>> allControllerDevices) {
        Set regions = this.regionService.getRegions();
        if (regions.isEmpty()) {
            return false;
        }
        HashSet nodesInRegions = Sets.newHashSet();
        for (Region region : regions) {
            Map<ControllerNode, Set<DeviceId>> activeRegionControllers = this.balanceRolesInRegion(region, allControllerDevices);
            nodesInRegions.addAll(activeRegionControllers.keySet());
        }
        Sets.SetView nodesNotInRegions = Sets.difference(allControllerDevices.keySet(), (Set)nodesInRegions);
        if (!nodesNotInRegions.isEmpty()) {
            int deviceCount = 0;
            HashMap<ControllerNode, Set<DeviceId>> controllerDevicesNotInRegions = new HashMap<ControllerNode, Set<DeviceId>>();
            for (ControllerNode controllerNode : nodesNotInRegions) {
                controllerDevicesNotInRegions.put(controllerNode, allControllerDevices.get(controllerNode));
                deviceCount += allControllerDevices.get(controllerNode).size();
            }
            List<CompletableFuture<Void>> balanceBucketsFutures = this.balanceControllerNodes(controllerDevicesNotInRegions, deviceCount);
            CompletableFuture<Void> balanceRolesFuture = CompletableFuture.allOf(balanceBucketsFutures.toArray(new CompletableFuture[balanceBucketsFutures.size()]));
            Futures.getUnchecked(balanceRolesFuture);
        }
        return true;
    }

    private Map<ControllerNode, Set<DeviceId>> balanceRolesInRegion(Region region, Map<ControllerNode, Set<DeviceId>> allControllerDevices) {
        Set devicesInRegion = this.regionService.getRegionDevices(region.id());
        this.log.info("Region {} has {} devices.", (Object)region.id(), (Object)devicesInRegion.size());
        if (devicesInRegion.isEmpty()) {
            return new HashMap<ControllerNode, Set<DeviceId>>();
        }
        List mastersList = region.masters();
        this.log.info("Region {} has {} sets of masters.", (Object)region.id(), (Object)mastersList.size());
        if (mastersList.isEmpty()) {
            return new HashMap<ControllerNode, Set<DeviceId>>();
        }
        HashSet devicesInMasters = Sets.newHashSet();
        Map<ControllerNode, Set<DeviceId>> regionalControllerDevices = this.getRegionsPreferredMasters(region, devicesInMasters, allControllerDevices);
        List<CompletableFuture<Void>> balanceBucketsFutures = this.balanceControllerNodes(regionalControllerDevices, devicesInMasters.size());
        Sets.SetView devicesNotMasteredWithControllers = Sets.difference((Set)devicesInRegion, (Set)devicesInMasters);
        if (!devicesNotMasteredWithControllers.isEmpty()) {
            ArrayList<ControllerNode> sorted = new ArrayList<ControllerNode>(regionalControllerDevices.keySet());
            Collections.sort(sorted, (o1, o2) -> Integer.valueOf(((Set)regionalControllerDevices.get(o1)).size()).compareTo(((Set)regionalControllerDevices.get(o2)).size()));
            int deviceIndex = 0;
            for (DeviceId deviceId : devicesNotMasteredWithControllers) {
                ControllerNode cnode = (ControllerNode)sorted.get(deviceIndex % sorted.size());
                balanceBucketsFutures.add(this.setRole(cnode.id(), deviceId, MastershipRole.MASTER));
                regionalControllerDevices.get(cnode).add(deviceId);
                ++deviceIndex;
            }
        }
        CompletableFuture<Void> balanceRolesFuture = CompletableFuture.allOf(balanceBucketsFutures.toArray(new CompletableFuture[balanceBucketsFutures.size()]));
        Futures.getUnchecked(balanceRolesFuture);
        regionalControllerDevices.forEach((controllerNode, deviceIds) -> regionalControllerDevices.put((ControllerNode)controllerNode, (Set<DeviceId>)new HashSet<DeviceId>(this.getDevicesOf(controllerNode.id()))));
        return regionalControllerDevices;
    }

    private Map<ControllerNode, Set<DeviceId>> getRegionsPreferredMasters(Region region, Set<DeviceId> devicesInMasters, Map<ControllerNode, Set<DeviceId>> allControllerDevices) {
        HashMap<ControllerNode, Set<DeviceId>> regionalControllerDevices = new HashMap<ControllerNode, Set<DeviceId>>();
        int listIndex = 0;
        for (Set masterSet : region.masters()) {
            this.log.info("Region {} masters set {} has {} nodes.", new Object[]{region.id(), listIndex, masterSet.size()});
            if (masterSet.isEmpty()) {
                ++listIndex;
                continue;
            }
            for (NodeId nodeId : masterSet) {
                if (!this.clusterService.getState(nodeId).isActive()) continue;
                ControllerNode controllerNode = this.clusterService.getNode(nodeId);
                HashSet devicesOf = new HashSet(allControllerDevices.get(controllerNode));
                regionalControllerDevices.put(controllerNode, devicesOf);
                devicesInMasters.addAll(devicesOf);
                this.log.info("Active Node {} has {} devices.", (Object)nodeId, (Object)devicesOf.size());
            }
            if (!regionalControllerDevices.isEmpty()) break;
            ++listIndex;
        }
        return regionalControllerDevices;
    }

    protected void bindStore(MastershipStore mastershipStore) {
        this.store = mastershipStore;
    }

    protected void unbindStore(MastershipStore mastershipStore) {
        if (this.store == mastershipStore) {
            this.store = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    protected void bindRegionService(RegionService regionService) {
        this.regionService = regionService;
    }

    protected void unbindRegionService(RegionService regionService) {
        if (this.regionService == regionService) {
            this.regionService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    public class InternalDelegate
    implements MastershipStoreDelegate {
        public void notify(MastershipEvent event) {
            MastershipManager.this.post((Event)event);
        }
    }
}

