/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipAdminService;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.LeadershipStore;
import org.onosproject.cluster.LeadershipStoreDelegate;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.EventSink;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class LeadershipManager
extends AbstractListenerManager<LeadershipEvent, LeadershipEventListener>
implements LeadershipService,
LeadershipAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private LeadershipStoreDelegate delegate = arg_0 -> ((LeadershipManager)this).post(arg_0);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipStore store;
    private NodeId localNodeId;

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(LeadershipEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        Maps.filterValues((Map)this.store.getLeaderships(), v -> v.candidates().contains(this.localNodeId)).keySet().forEach(this::withdraw);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(LeadershipEvent.class);
        this.log.info("Stopped");
    }

    public Leadership getLeadership(String topic) {
        return this.store.getLeadership(topic);
    }

    public Leadership runForLeadership(String topic) {
        return this.store.addRegistration(topic);
    }

    public void withdraw(String topic) {
        this.store.removeRegistration(topic);
    }

    public Map<String, Leadership> getLeaderBoard() {
        return this.store.getLeaderships();
    }

    public boolean transferLeadership(String topic, NodeId to) {
        return this.store.moveLeadership(topic, to);
    }

    public void unregister(NodeId nodeId) {
        this.store.removeRegistration(nodeId);
    }

    public boolean promoteToTopOfCandidateList(String topic, NodeId nodeId) {
        return this.store.makeTopCandidate(topic, nodeId);
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStore(LeadershipStore leadershipStore) {
        this.store = leadershipStore;
    }

    protected void unbindStore(LeadershipStore leadershipStore) {
        if (this.store == leadershipStore) {
            this.store = null;
        }
    }
}

