/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import com.google.common.collect.ImmutableSet;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataProvider;
import org.onosproject.cluster.ClusterMetadataProviderRegistry;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.PartitionId;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DefaultClusterMetadataProvider
implements ClusterMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataProviderRegistry providerRegistry;
    private static final String ONOS_IP = "ONOS_IP";
    private static final String ONOS_INTERFACE = "ONOS_INTERFACE";
    private static final String ONOS_ALLOW_IPV6 = "ONOS_ALLOW_IPV6";
    private static final String DEFAULT_ONOS_INTERFACE = "eth0";
    private static final int DEFAULT_ONOS_PORT = 9876;
    private static final ProviderId PROVIDER_ID = new ProviderId("default", "none");
    private final AtomicReference<Versioned<ClusterMetadata>> cachedMetadata = new AtomicReference();

    @Activate
    public void activate() {
        String localIp = DefaultClusterMetadataProvider.getSiteLocalAddress();
        DefaultControllerNode localNode = new DefaultControllerNode(new NodeId(localIp), IpAddress.valueOf((String)localIp), 9876);
        DefaultPartition partition = new DefaultPartition(PartitionId.from((int)1), (Collection)ImmutableSet.of((Object)localNode.id()));
        ClusterMetadata metadata = new ClusterMetadata(PROVIDER_ID, "default", (Set)ImmutableSet.of((Object)localNode), (Set)ImmutableSet.of((Object)partition));
        long version = System.currentTimeMillis();
        this.cachedMetadata.set((Versioned<ClusterMetadata>)new Versioned((Object)metadata, version));
        this.providerRegistry.register((Provider)this);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.log.info("Stopped");
    }

    public ProviderId id() {
        return PROVIDER_ID;
    }

    public Versioned<ClusterMetadata> getClusterMetadata() {
        return this.cachedMetadata.get();
    }

    public void setClusterMetadata(ClusterMetadata metadata) {
        throw new UnsupportedOperationException();
    }

    public void addActivePartitionMember(PartitionId partitionId, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    public void removeActivePartitionMember(PartitionId partitionId, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    public Set<NodeId> getActivePartitionMembers(PartitionId partitionId) {
        throw new UnsupportedOperationException();
    }

    public boolean isAvailable() {
        return true;
    }

    private static String getSiteLocalAddress() {
        String useOnosIp = System.getenv(ONOS_IP);
        if (useOnosIp != null) {
            return useOnosIp;
        }
        String useOnosInterface = System.getenv(ONOS_INTERFACE);
        if (useOnosInterface == null) {
            useOnosInterface = DEFAULT_ONOS_INTERFACE;
        }
        boolean allowIPv6 = System.getenv(ONOS_ALLOW_IPV6) != null;
        Function<NetworkInterface, IpAddress> ipLookup = nif -> {
            IpAddress fallback = null;
            if (nif != null) {
                for (InetAddress address : Collections.list(nif.getInetAddresses())) {
                    if (address.isSiteLocalAddress() && (allowIPv6 || address instanceof Inet4Address)) {
                        return IpAddress.valueOf((InetAddress)address);
                    }
                    if (fallback != null || address.isLoopbackAddress() || address.isMulticastAddress() || !allowIPv6 && !(address instanceof Inet4Address)) continue;
                    fallback = IpAddress.valueOf((InetAddress)address);
                }
            }
            return fallback;
        };
        try {
            IpAddress ip = ipLookup.apply(NetworkInterface.getByName(useOnosInterface));
            if (ip != null) {
                return ip.toString();
            }
            for (NetworkInterface nif2 : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (nif2.getName().equals(useOnosInterface) || (ip = ipLookup.apply(nif2)) == null) continue;
                return ip.toString();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get network interfaces", e);
        }
        return IpAddress.valueOf((InetAddress)InetAddress.getLoopbackAddress()).toString();
    }

    protected void bindProviderRegistry(ClusterMetadataProviderRegistry clusterMetadataProviderRegistry) {
        this.providerRegistry = clusterMetadataProviderRegistry;
    }

    protected void unbindProviderRegistry(ClusterMetadataProviderRegistry clusterMetadataProviderRegistry) {
        if (this.providerRegistry == clusterMetadataProviderRegistry) {
            this.providerRegistry = null;
        }
    }
}

