/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataProvider;
import org.onosproject.cluster.ClusterMetadataProviderRegistry;
import org.onosproject.cluster.ClusterMetadataProviderService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ConfigFileBasedClusterMetadataProvider
implements ClusterMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ID = "id";
    private static final String PORT = "port";
    private static final String IP = "ip";
    private static final String CONFIG_DIR = "../config";
    private static final String CONFIG_FILE_NAME = "cluster.json";
    private static final File CONFIG_FILE = new File("../config", "cluster.json");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataProviderRegistry providerRegistry;
    private static final ProviderId PROVIDER_ID = new ProviderId("file", "none");
    private final AtomicReference<Versioned<ClusterMetadata>> cachedMetadata = new AtomicReference();
    private final ScheduledExecutorService configFileChangeDetector = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/cluster/metadata/config-watcher", (String)"", (Logger)this.log));
    private String metadataUrl;
    private ObjectMapper mapper;
    private ClusterMetadataProviderService providerService;

    @Activate
    public void activate() {
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(NodeId.class, (JsonSerializer)new NodeIdSerializer());
        module.addDeserializer(NodeId.class, (JsonDeserializer)new NodeIdDeserializer());
        module.addSerializer(ControllerNode.class, (JsonSerializer)new ControllerNodeSerializer());
        module.addDeserializer(ControllerNode.class, (JsonDeserializer)new ControllerNodeDeserializer());
        module.addDeserializer(Partition.class, (JsonDeserializer)new PartitionDeserializer());
        module.addSerializer(PartitionId.class, (JsonSerializer)new PartitionIdSerializer());
        module.addDeserializer(PartitionId.class, (JsonDeserializer)new PartitionIdDeserializer());
        this.mapper.registerModule((Module)module);
        this.providerService = (ClusterMetadataProviderService)this.providerRegistry.register((Provider)this);
        this.metadataUrl = System.getProperty("onos.cluster.metadata.uri", "file://../config/" + CONFIG_FILE);
        this.configFileChangeDetector.scheduleWithFixedDelay(() -> this.watchUrl(this.metadataUrl), 100L, 500L, TimeUnit.MILLISECONDS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.configFileChangeDetector.shutdown();
        this.providerRegistry.unregister((Provider)this);
        this.log.info("Stopped");
    }

    public ProviderId id() {
        return PROVIDER_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Versioned<ClusterMetadata> getClusterMetadata() {
        Preconditions.checkState((boolean)this.isAvailable());
        ConfigFileBasedClusterMetadataProvider configFileBasedClusterMetadataProvider = this;
        synchronized (configFileBasedClusterMetadataProvider) {
            if (this.cachedMetadata.get() == null) {
                this.cachedMetadata.set(this.fetchMetadata(this.metadataUrl));
            }
            return this.cachedMetadata.get();
        }
    }

    public void setClusterMetadata(ClusterMetadata metadata) {
        try {
            Files.createParentDirs((File)CONFIG_FILE);
            this.mapper.writeValue(CONFIG_FILE, (Object)metadata);
            this.providerService.clusterMetadataChanged(new Versioned((Object)metadata, CONFIG_FILE.lastModified()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void addActivePartitionMember(PartitionId partitionId, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    public void removeActivePartitionMember(PartitionId partitionId, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    public Set<NodeId> getActivePartitionMembers(PartitionId partitionId) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAvailable() {
        try {
            URL url = new URL(this.metadataUrl);
            if ("file".equals(url.getProtocol())) {
                File file2 = new File(this.metadataUrl.replaceFirst("file://", ""));
                return file2.exists();
            }
            if (!"http".equals(url.getProtocol())) return false;
            try (InputStream file = url.openStream();){
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.log.warn("Exception accessing metadata file at {}:", (Object)this.metadataUrl, (Object)e);
            return false;
        }
    }

    private Versioned<ClusterMetadata> fetchMetadata(String metadataUrl) {
        try {
            URL url = new URL(metadataUrl);
            ClusterMetadata metadata = null;
            long version = 0L;
            if ("file".equals(url.getProtocol())) {
                File file = new File(metadataUrl.replaceFirst("file://", ""));
                version = file.lastModified();
                metadata = (ClusterMetadata)this.mapper.readValue((InputStream)new FileInputStream(file), ClusterMetadata.class);
            } else if ("http".equals(url.getProtocol())) {
                URLConnection conn = url.openConnection();
                version = conn.getLastModified();
                metadata = (ClusterMetadata)this.mapper.readValue(conn.getInputStream(), ClusterMetadata.class);
            }
            if (null == metadata) {
                this.log.warn("Metadata is null in the function fetchMetadata");
                throw new NullPointerException();
            }
            return new Versioned((Object)new ClusterMetadata(PROVIDER_ID, metadata.getName(), (Set)Sets.newHashSet((Iterable)metadata.getNodes()), (Set)Sets.newHashSet((Iterable)metadata.getPartitions())), version);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void watchUrl(String metadataUrl) {
        Versioned<ClusterMetadata> latestMetadata = this.fetchMetadata(metadataUrl);
        if (this.cachedMetadata.get() != null && this.cachedMetadata.get().version() < latestMetadata.version()) {
            this.cachedMetadata.set(latestMetadata);
            this.providerService.clusterMetadataChanged(latestMetadata);
        }
    }

    protected void bindProviderRegistry(ClusterMetadataProviderRegistry clusterMetadataProviderRegistry) {
        this.providerRegistry = clusterMetadataProviderRegistry;
    }

    protected void unbindProviderRegistry(ClusterMetadataProviderRegistry clusterMetadataProviderRegistry) {
        if (this.providerRegistry == clusterMetadataProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    private class NodeIdDeserializer
    extends JsonDeserializer<NodeId> {
        private NodeIdDeserializer() {
        }

        public NodeId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new NodeId(node.asText());
        }
    }

    private static class NodeIdSerializer
    extends JsonSerializer<NodeId> {
        private NodeIdSerializer() {
        }

        public void serialize(NodeId nodeId, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(nodeId.toString());
        }
    }

    private static class ControllerNodeDeserializer
    extends JsonDeserializer<ControllerNode> {
        private ControllerNodeDeserializer() {
        }

        public ControllerNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            NodeId nodeId = new NodeId(node.get(ConfigFileBasedClusterMetadataProvider.ID).textValue());
            IpAddress ip = IpAddress.valueOf((String)node.get(ConfigFileBasedClusterMetadataProvider.IP).textValue());
            int port = node.get(ConfigFileBasedClusterMetadataProvider.PORT).asInt();
            return new DefaultControllerNode(nodeId, ip, port);
        }
    }

    private static class ControllerNodeSerializer
    extends JsonSerializer<ControllerNode> {
        private ControllerNodeSerializer() {
        }

        public void serialize(ControllerNode node, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField(ConfigFileBasedClusterMetadataProvider.ID, node.id().toString());
            jgen.writeStringField(ConfigFileBasedClusterMetadataProvider.IP, node.ip().toString());
            jgen.writeNumberField(ConfigFileBasedClusterMetadataProvider.PORT, node.tcpPort());
            jgen.writeEndObject();
        }
    }

    private class PartitionIdDeserializer
    extends JsonDeserializer<PartitionId> {
        private PartitionIdDeserializer() {
        }

        public PartitionId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new PartitionId(node.asInt());
        }
    }

    private static class PartitionIdSerializer
    extends JsonSerializer<PartitionId> {
        private PartitionIdSerializer() {
        }

        public void serialize(PartitionId partitionId, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(partitionId.asInt());
        }
    }

    private static class PartitionDeserializer
    extends JsonDeserializer<Partition> {
        private PartitionDeserializer() {
        }

        public Partition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return (Partition)jp.readValueAs(DefaultPartition.class);
        }
    }
}

