/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.onlab.util.SharedScheduledExecutors;
import org.onosproject.cluster.ClusterAdminService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ComponentsMonitor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long PERIOD = 2500L;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FeaturesService featuresService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ScrService scrService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterAdminService clusterAdminService;
    private BundleContext bundleContext;
    private ScheduledFuture<?> poller;

    @Activate
    protected void activate(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
        this.poller = SharedScheduledExecutors.getSingleThreadExecutor().scheduleAtFixedRate(this::checkStartedState, 2500L, 2500L, TimeUnit.MILLISECONDS);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.poller.cancel(false);
        this.log.info("Stopped");
    }

    private void checkStartedState() {
        this.clusterAdminService.markFullyStarted(this.isFullyStarted());
    }

    private boolean isFullyStarted() {
        for (Feature feature : this.featuresService.listInstalledFeatures()) {
            if (this.isFullyStarted(feature)) continue;
            return false;
        }
        return true;
    }

    private boolean isFullyStarted(Feature feature) {
        try {
            return feature.getBundles().stream().map(info -> this.bundleContext.getBundle(info.getLocation())).allMatch(this::isFullyStarted);
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    private boolean isFullyStarted(Bundle bundle) {
        org.apache.felix.scr.Component[] components = this.scrService.getComponents(bundle);
        if (components != null) {
            for (org.apache.felix.scr.Component component : components) {
                if (this.isFullyStarted(component)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFullyStarted(org.apache.felix.scr.Component component) {
        int state = component.getState();
        return state == 16 || state == 1 || state == 32 && !component.isImmediate();
    }

    protected void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected void unbindFeaturesService(FeaturesService featuresService) {
        if (this.featuresService == featuresService) {
            this.featuresService = null;
        }
    }

    protected void bindScrService(ScrService scrService) {
        this.scrService = scrService;
    }

    protected void unbindScrService(ScrService scrService) {
        if (this.scrService == scrService) {
            this.scrService = null;
        }
    }

    protected void bindClusterAdminService(ClusterAdminService clusterAdminService) {
        this.clusterAdminService = clusterAdminService;
    }

    protected void unbindClusterAdminService(ClusterAdminService clusterAdminService) {
        if (this.clusterAdminService == clusterAdminService) {
            this.clusterAdminService = null;
        }
    }
}

