/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataAdminService;
import org.onosproject.cluster.ClusterMetadataEvent;
import org.onosproject.cluster.ClusterMetadataEventListener;
import org.onosproject.cluster.ClusterMetadataProvider;
import org.onosproject.cluster.ClusterMetadataProviderRegistry;
import org.onosproject.cluster.ClusterMetadataProviderService;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.PartitionId;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.net.provider.AbstractListenerProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ClusterMetadataManager
extends AbstractListenerProviderRegistry<ClusterMetadataEvent, ClusterMetadataEventListener, ClusterMetadataProvider, ClusterMetadataProviderService>
implements ClusterMetadataService,
ClusterMetadataAdminService,
ClusterMetadataProviderRegistry {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ControllerNode localNode;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(ClusterMetadataEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(ClusterMetadataEvent.class);
        this.log.info("Stopped");
    }

    public ClusterMetadata getClusterMetadata() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Versioned metadata = this.getProvider().getClusterMetadata();
        return (ClusterMetadata)metadata.value();
    }

    protected ClusterMetadataProviderService createProviderService(ClusterMetadataProvider provider) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        return new InternalClusterMetadataProviderService(provider);
    }

    public ControllerNode getLocalNode() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        if (this.localNode == null) {
            this.establishSelfIdentity();
        }
        return this.localNode;
    }

    public void setClusterMetadata(ClusterMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata, (Object)"Cluster metadata cannot be null");
        ClusterMetadataProvider primaryProvider = this.getPrimaryProvider();
        if (primaryProvider == null) {
            throw new IllegalStateException("Missing primary provider. Cannot update cluster metadata");
        }
        primaryProvider.setClusterMetadata(metadata);
    }

    private ClusterMetadataProvider getProvider() {
        ClusterMetadataProvider primaryProvider = this.getPrimaryProvider();
        if (primaryProvider != null && primaryProvider.isAvailable()) {
            return primaryProvider;
        }
        return (ClusterMetadataProvider)this.getProvider("default");
    }

    private ClusterMetadataProvider getPrimaryProvider() {
        String metadataUri = System.getProperty("onos.cluster.metadata.uri");
        try {
            String protocol;
            String string = protocol = metadataUri == null ? null : new URL(metadataUri).getProtocol();
            if (protocol != null && !"file".equals(protocol) && !"http".equals(protocol)) {
                return (ClusterMetadataProvider)this.getProvider(protocol);
            }
            return (ClusterMetadataProvider)this.getProvider("file");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private IpAddress findLocalIp(Collection<ControllerNode> controllerNodes) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                IpAddress ip = IpAddress.valueOf((InetAddress)inetAddresses.nextElement());
                if (!controllerNodes.stream().map(ControllerNode::ip).anyMatch(nodeIp -> ip.equals(nodeIp))) continue;
                return ip;
            }
        }
        throw new IllegalStateException("Unable to determine local ip");
    }

    private void establishSelfIdentity() {
        try {
            IpAddress ip = this.findLocalIp(this.getClusterMetadata().getNodes());
            this.localNode = this.getClusterMetadata().getNodes().stream().filter(node -> node.ip().equals((Object)ip)).findFirst().get();
        }
        catch (SocketException e) {
            throw new IllegalStateException("Cannot determine local IP", e);
        }
    }

    private class InternalClusterMetadataProviderService
    extends AbstractProviderService<ClusterMetadataProvider>
    implements ClusterMetadataProviderService {
        InternalClusterMetadataProviderService(ClusterMetadataProvider provider) {
            super((Provider)provider);
        }

        public void clusterMetadataChanged(Versioned<ClusterMetadata> newMetadata) {
            ClusterMetadataManager.this.log.info("Cluster metadata changed. New metadata: {}", newMetadata);
            ClusterMetadataManager.this.post((Event)new ClusterMetadataEvent(ClusterMetadataEvent.Type.METADATA_CHANGED, (ClusterMetadata)newMetadata.value()));
        }

        public void newActiveMemberForPartition(PartitionId partitionId, NodeId nodeId) {
            ClusterMetadataManager.this.log.info("Node {} is active member for partition {}", (Object)nodeId, (Object)partitionId);
        }
    }
}

