/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.system.SystemService;
import org.joda.time.DateTime;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataAdminService;
import org.onosproject.cluster.ClusterMetadataDiff;
import org.onosproject.cluster.ClusterMetadataEvent;
import org.onosproject.cluster.ClusterMetadataEventListener;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ClusterStore;
import org.onosproject.cluster.ClusterStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ClusterManager
extends AbstractListenerManager<ClusterEvent, ClusterEventListener>
implements ClusterService,
ClusterAdminService {
    public static final String INSTANCE_ID_NULL = "Instance ID cannot be null";
    private static final int DEFAULT_PARTITION_SIZE = 3;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ClusterStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataService clusterMetadataService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataAdminService clusterMetadataAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SystemService systemService;
    private final AtomicReference<ClusterMetadata> currentMetadata = new AtomicReference();
    private final InternalClusterMetadataListener metadataListener = new InternalClusterMetadataListener();

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.addSink(ClusterEvent.class, (EventSink)this.listenerRegistry);
        this.clusterMetadataService.addListener((EventListener)this.metadataListener);
        this.processMetadata(this.clusterMetadataService.getClusterMetadata());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.clusterMetadataService.removeListener((EventListener)this.metadataListener);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.eventDispatcher.removeSink(ClusterEvent.class);
        this.log.info("Stopped");
    }

    public ControllerNode getLocalNode() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        return this.store.getLocalNode();
    }

    public Set<ControllerNode> getNodes() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        return this.store.getNodes();
    }

    public ControllerNode getNode(NodeId nodeId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.store.getNode(nodeId);
    }

    public ControllerNode.State getState(NodeId nodeId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.store.getState(nodeId);
    }

    public void markFullyStarted(boolean started) {
        this.store.markFullyStarted(started);
    }

    public DateTime getLastUpdated(NodeId nodeId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CLUSTER_READ);
        return this.store.getLastUpdated(nodeId);
    }

    public void formCluster(Set<ControllerNode> nodes) {
        this.formCluster(nodes, 3);
    }

    public void formCluster(Set<ControllerNode> nodes, int partitionSize) {
        Preconditions.checkNotNull(nodes, (Object)"Nodes cannot be null");
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"Nodes cannot be empty");
        ClusterMetadata metadata = new ClusterMetadata("default", nodes, ClusterManager.buildDefaultPartitions(nodes, partitionSize));
        this.clusterMetadataAdminService.setClusterMetadata(metadata);
        try {
            this.log.warn("Shutting down container for cluster reconfiguration!");
            Tools.removeDirectory((String)(System.getProperty("karaf.data") + "/partitions"));
            this.systemService.reboot("now", SystemService.Swipe.NONE);
        }
        catch (Exception e) {
            this.log.error("Unable to reboot container", (Throwable)e);
        }
    }

    public ControllerNode addNode(NodeId nodeId, IpAddress ip, int tcpPort) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        Preconditions.checkNotNull((Object)ip, (Object)"IP address cannot be null");
        Preconditions.checkArgument((tcpPort > 5000 ? 1 : 0) != 0, (Object)"TCP port must be > 5000");
        return this.store.addNode(nodeId, ip, tcpPort);
    }

    public void removeNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        this.store.removeNode(nodeId);
    }

    private static Set<Partition> buildDefaultPartitions(Collection<ControllerNode> nodes, int partitionSize) {
        ArrayList<ControllerNode> sorted = new ArrayList<ControllerNode>(nodes);
        Collections.sort(sorted, (o1, o2) -> o1.id().toString().compareTo(o2.id().toString()));
        HashSet partitions = Sets.newHashSet();
        int length = nodes.size();
        int count = Math.min(partitionSize, length);
        for (int i = 0; i < length; ++i) {
            int index = i;
            HashSet<NodeId> set = new HashSet<NodeId>(count);
            for (int j = 0; j < count; ++j) {
                set.add(((ControllerNode)sorted.get((i + j) % length)).id());
            }
            partitions.add(new DefaultPartition(PartitionId.from((int)(index + 1)), set));
        }
        return partitions;
    }

    private synchronized void processMetadata(ClusterMetadata metadata) {
        try {
            ClusterMetadataDiff examiner = new ClusterMetadataDiff(this.currentMetadata.get(), metadata);
            examiner.nodesAdded().forEach(node -> this.addNode(node.id(), node.ip(), node.tcpPort()));
            examiner.nodesRemoved().forEach(this::removeNode);
        }
        finally {
            this.currentMetadata.set(metadata);
        }
    }

    protected void bindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        this.clusterMetadataService = clusterMetadataService;
    }

    protected void unbindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        if (this.clusterMetadataService == clusterMetadataService) {
            this.clusterMetadataService = null;
        }
    }

    protected void bindClusterMetadataAdminService(ClusterMetadataAdminService clusterMetadataAdminService) {
        this.clusterMetadataAdminService = clusterMetadataAdminService;
    }

    protected void unbindClusterMetadataAdminService(ClusterMetadataAdminService clusterMetadataAdminService) {
        if (this.clusterMetadataAdminService == clusterMetadataAdminService) {
            this.clusterMetadataAdminService = null;
        }
    }

    protected void bindStore(ClusterStore clusterStore) {
        this.store = clusterStore;
    }

    protected void unbindStore(ClusterStore clusterStore) {
        if (this.store == clusterStore) {
            this.store = null;
        }
    }

    protected void bindSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    protected void unbindSystemService(SystemService systemService) {
        if (this.systemService == systemService) {
            this.systemService = null;
        }
    }

    private class InternalClusterMetadataListener
    implements ClusterMetadataEventListener {
        private InternalClusterMetadataListener() {
        }

        public void event(ClusterMetadataEvent event) {
            ClusterManager.this.processMetadata((ClusterMetadata)event.subject());
        }
    }

    private class InternalStoreDelegate
    implements ClusterStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(ClusterEvent event) {
            ClusterManager.this.post((Event)event);
        }
    }
}

