/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cfg.impl;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import org.onosproject.cfg.ConfigProperty;

public final class ConfigPropertyDefinitions {
    private static final String FMT = "%s|%s|%s|%s\n";
    private static final String SEP = "\\|";
    private static final String COMMENT = "#";

    private ConfigPropertyDefinitions() {
    }

    public static void write(OutputStream stream, Set<ConfigProperty> props) throws IOException {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(stream));){
            props.forEach(p -> pw.format(FMT, p.name(), p.type(), p.description(), p.defaultValue()));
        }
    }

    public static Set<ConfigProperty> read(InputStream stream) throws IOException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith(COMMENT)) continue;
                String[] f = line.split(SEP, 4);
                builder.add((Object)ConfigProperty.defineProperty((String)f[0], (ConfigProperty.Type)ConfigProperty.Type.valueOf((String)f[1]), (String)f[2], (String)f[3]));
            }
        }
        return builder.build();
    }
}

