/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cfg.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.AbstractAccumulator;
import org.onlab.util.Accumulator;
import org.onlab.util.SharedExecutors;
import org.onosproject.cfg.ComponentConfigEvent;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cfg.ComponentConfigStore;
import org.onosproject.cfg.ComponentConfigStoreDelegate;
import org.onosproject.cfg.ConfigProperty;
import org.onosproject.cfg.impl.ConfigPropertyDefinitions;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.StoreDelegate;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ComponentConfigManager
implements ComponentConfigService {
    private static final String COMPONENT_NULL = "Component name cannot be null";
    private static final String PROPERTY_NULL = "Property name cannot be null";
    private static final String COMPONENT_MISSING = "Component %s is not registered";
    private static final String PROPERTY_MISSING = "Property %s does not exist for %s";
    private static final int MAX_ITEMS = 100;
    private static final int MAX_BATCH_MILLIS = 1000;
    private static final int MAX_IDLE_MILLIS = 250;
    private static final String RESOURCE_EXT = ".cfgdef";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ComponentConfigStoreDelegate delegate = new InternalStoreDelegate();
    private final InternalAccumulator accumulator = new InternalAccumulator();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ConfigurationAdmin cfgAdmin;
    private final Map<String, Map<String, ConfigProperty>> properties = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.log.info("Stopped");
    }

    public Set<String> getComponentNames() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        return ImmutableSet.copyOf(this.properties.keySet());
    }

    public void registerProperties(Class<?> componentClass) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        String componentName = componentClass.getName();
        String resourceName = componentClass.getSimpleName() + RESOURCE_EXT;
        try (InputStream ris = componentClass.getResourceAsStream(resourceName);){
            Preconditions.checkArgument((ris != null ? 1 : 0) != 0, (String)"Property definitions not found at resource %s", (Object)resourceName);
            Set<ConfigProperty> defs = ConfigPropertyDefinitions.read(ris);
            ConcurrentMap map = Maps.newConcurrentMap();
            defs.forEach(p -> map.put(p.name(), p));
            this.properties.put(componentName, map);
            this.loadExistingValues(componentName);
        }
        catch (IOException e) {
            this.log.error("Unable to read property definitions from resource " + resourceName, (Throwable)e);
        }
    }

    public void unregisterProperties(Class<?> componentClass, boolean clear) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        String componentName = componentClass.getName();
        Preconditions.checkNotNull((Object)componentName, (Object)COMPONENT_NULL);
        Map<String, ConfigProperty> cps = this.properties.remove(componentName);
        if (clear && cps != null) {
            cps.keySet().forEach(name -> this.store.unsetProperty(componentName, name));
            this.clearExistingValues(componentName);
        }
    }

    private void clearExistingValues(String componentName) {
        this.triggerUpdate(componentName);
    }

    public Set<ConfigProperty> getProperties(String componentName) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_READ);
        Map<String, ConfigProperty> map = this.properties.get(componentName);
        return map != null ? ImmutableSet.copyOf(map.values()) : null;
    }

    public void setProperty(String componentName, String name, String value) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull((Object)componentName, (Object)COMPONENT_NULL);
        Preconditions.checkNotNull((Object)name, (Object)PROPERTY_NULL);
        Preconditions.checkArgument((boolean)this.properties.containsKey(componentName), (String)COMPONENT_MISSING, (Object)componentName);
        Preconditions.checkArgument((boolean)this.properties.get(componentName).containsKey(name), (String)PROPERTY_MISSING, (Object)name, (Object)componentName);
        this.checkValidity(componentName, name, value);
        this.store.setProperty(componentName, name, value);
    }

    public void preSetProperty(String componentName, String name, String value) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull((Object)componentName, (Object)COMPONENT_NULL);
        Preconditions.checkNotNull((Object)name, (Object)PROPERTY_NULL);
        this.checkValidity(componentName, name, value);
        this.store.setProperty(componentName, name, value);
    }

    public void unsetProperty(String componentName, String name) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.CONFIG_WRITE);
        Preconditions.checkNotNull((Object)componentName, (Object)COMPONENT_NULL);
        Preconditions.checkNotNull((Object)name, (Object)PROPERTY_NULL);
        Preconditions.checkArgument((boolean)this.properties.containsKey(componentName), (String)COMPONENT_MISSING, (Object)componentName);
        Preconditions.checkArgument((boolean)this.properties.get(componentName).containsKey(name), (String)PROPERTY_MISSING, (Object)name, (Object)componentName);
        this.store.unsetProperty(componentName, name);
    }

    private void set(String componentName, String name, String value) {
        ConfigProperty prop;
        Map<String, ConfigProperty> map = this.properties.get(componentName);
        if (map != null && (prop = map.get(name)) != null) {
            map.put(name, ConfigProperty.setProperty((ConfigProperty)prop, (String)value));
            this.accumulator.add(componentName);
            return;
        }
        this.preSet(componentName, name, value);
    }

    private void reset(String componentName, String name) {
        Map<String, ConfigProperty> map = this.properties.get(componentName);
        if (map != null) {
            ConfigProperty prop = map.get(name);
            if (prop != null) {
                map.put(name, ConfigProperty.resetProperty((ConfigProperty)prop));
                this.accumulator.add(componentName);
                return;
            }
            this.log.warn("Unable to reset non-existent property {} for component {}", (Object)name, (Object)componentName);
        }
    }

    private void preSet(String componentName, String name, String value) {
        try {
            Configuration config = this.cfgAdmin.getConfiguration(componentName, null);
            Hashtable<String, String> property = config.getProperties();
            if (property == null) {
                property = new Hashtable<String, String>();
            }
            ((Dictionary)property).put(name, value);
            config.update(property);
        }
        catch (IOException e) {
            this.log.error("Failed to preset configuration for {}", (Object)componentName);
        }
    }

    private void checkValidity(String componentName, String name, String newValue) {
        Map<String, ConfigProperty> map = this.properties.get(componentName);
        if (map == null) {
            return;
        }
        ConfigProperty prop = map.get(name);
        ConfigProperty.Type type = prop.type();
        try {
            switch (type) {
                case INTEGER: {
                    Integer.parseInt(newValue);
                    break;
                }
                case LONG: {
                    Long.parseLong(newValue);
                    break;
                }
                case FLOAT: {
                    Float.parseFloat(newValue);
                    break;
                }
                case DOUBLE: {
                    Double.parseDouble(newValue);
                    break;
                }
                case BOOLEAN: {
                    if (newValue == null || !newValue.equalsIgnoreCase("true") && !newValue.equalsIgnoreCase("false")) {
                        throw new IllegalArgumentException("Invalid " + type + " value");
                    }
                    break;
                }
                case STRING: 
                case BYTE: {
                    break;
                }
                default: {
                    this.log.warn("Not a valid config property type");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid " + type + " value");
        }
    }

    private void loadExistingValues(String componentName) {
        try {
            Configuration cfg = this.cfgAdmin.getConfiguration(componentName, null);
            Map<String, ConfigProperty> map = this.properties.get(componentName);
            Dictionary props = cfg.getProperties();
            if (props != null) {
                Enumeration it = props.keys();
                while (it.hasMoreElements()) {
                    String name = (String)it.nextElement();
                    ConfigProperty p = map.get(name);
                    try {
                        if (p == null) continue;
                        this.checkValidity(componentName, name, (String)props.get(name));
                        map.put(name, ConfigProperty.setProperty((ConfigProperty)p, (String)((String)props.get(name))));
                    }
                    catch (IllegalArgumentException e) {
                        this.log.warn("Default values will be applied since presetted value is not a valid " + p.type());
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.error("Unable to get configuration for " + componentName, (Throwable)e);
        }
    }

    private void triggerUpdate(String componentName) {
        try {
            Configuration cfg = this.cfgAdmin.getConfiguration(componentName, null);
            Map<String, ConfigProperty> map = this.properties.get(componentName);
            Hashtable props = new Hashtable();
            map.values().forEach(p -> props.put(p.name(), p.value()));
            cfg.update(props);
        }
        catch (IOException e) {
            this.log.warn("Unable to update configuration for " + componentName, (Throwable)e);
        }
    }

    protected void bindStore(ComponentConfigStore componentConfigStore) {
        this.store = componentConfigStore;
    }

    protected void unbindStore(ComponentConfigStore componentConfigStore) {
        if (this.store == componentConfigStore) {
            this.store = null;
        }
    }

    protected void bindCfgAdmin(ConfigurationAdmin configurationAdmin) {
        this.cfgAdmin = configurationAdmin;
    }

    protected void unbindCfgAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.cfgAdmin == configurationAdmin) {
            this.cfgAdmin = null;
        }
    }

    private class InternalAccumulator
    extends AbstractAccumulator<String>
    implements Accumulator<String> {
        protected InternalAccumulator() {
            super(SharedExecutors.getTimer(), 100, 1000, 250);
        }

        public void processItems(List<String> items) {
            HashSet<String> componentSet = new HashSet<String>(items);
            componentSet.forEach(x$0 -> ComponentConfigManager.this.triggerUpdate(x$0));
        }
    }

    private class InternalStoreDelegate
    implements ComponentConfigStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(ComponentConfigEvent event) {
            String componentName = (String)event.subject();
            String name = event.name();
            String value = event.value();
            switch ((ComponentConfigEvent.Type)event.type()) {
                case PROPERTY_SET: {
                    ComponentConfigManager.this.set(componentName, name, value);
                    break;
                }
                case PROPERTY_UNSET: {
                    ComponentConfigManager.this.reset(componentName, name);
                    break;
                }
            }
        }
    }
}

