/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cfg.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.cfg.ComponentConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ComponentConfigLoader {
    private static final String CFG_JSON = "../config/component-cfg.json";
    static File cfgFile = new File("../config/component-cfg.json");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    private ObjectNode root;

    @Activate
    protected void activate() {
        this.loadConfigs();
        this.log.info("Started");
    }

    private void loadConfigs() {
        try {
            if (cfgFile.exists()) {
                this.root = (ObjectNode)new ObjectMapper().readTree(cfgFile);
                this.root.fieldNames().forEachRemaining(component -> this.root.path(component).fieldNames().forEachRemaining(k -> this.configService.preSetProperty(component, k, this.root.path(component).path(k).asText())));
                this.log.info("Loaded initial component configuration from {}", (Object)cfgFile);
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to load initial component configuration from {}", (Object)cfgFile, (Object)e);
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }
}

