/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationListener;
import org.onosproject.app.ApplicationService;
import org.onosproject.app.ApplicationState;
import org.onosproject.app.ApplicationStore;
import org.onosproject.app.ApplicationStoreDelegate;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.security.Permission;
import org.onosproject.security.SecurityUtil;
import org.onosproject.store.StoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ApplicationManager
extends AbstractListenerManager<ApplicationEvent, ApplicationListener>
implements ApplicationService,
ApplicationAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String APP_ID_NULL = "Application ID cannot be null";
    private static final long DEFAULT_OPERATION_TIMEOUT_MILLIS = 2000L;
    private final ApplicationStoreDelegate delegate = new InternalStoreDelegate();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FeaturesService featuresService;
    private final Multimap<String, Runnable> deactivateHooks = HashMultimap.create();
    private final Cache<ApplicationId, CountDownLatch> pendingOperations = CacheBuilder.newBuilder().expireAfterWrite(4000L, TimeUnit.MILLISECONDS).build();

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(ApplicationEvent.class, (EventSink)this.listenerRegistry);
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(ApplicationEvent.class);
        this.store.unsetDelegate((StoreDelegate)this.delegate);
        this.log.info("Stopped");
    }

    public Set<Application> getApplications() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        return this.store.getApplications();
    }

    public ApplicationId getId(String name) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this.store.getId(name);
    }

    public Application getApplication(ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        return this.store.getApplication(appId);
    }

    public ApplicationState getState(ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        return this.store.getState(appId);
    }

    public Set<Permission> getPermissions(ApplicationId appId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        return this.store.getPermissions(appId);
    }

    public void registerDeactivateHook(ApplicationId appId, Runnable hook) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.APP_READ);
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        Preconditions.checkNotNull((Object)hook, (Object)"Hook cannot be null");
        this.deactivateHooks.put((Object)appId.name(), (Object)hook);
    }

    public Application install(InputStream appDescStream) {
        Preconditions.checkNotNull((Object)appDescStream, (Object)"Application archive stream cannot be null");
        Application app = this.store.create(appDescStream);
        SecurityUtil.register((ApplicationId)app.id());
        return app;
    }

    public void uninstall(ApplicationId appId) {
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        this.updateStoreAndWaitForNotificationHandling(appId, arg_0 -> ((ApplicationStore)this.store).remove(arg_0));
    }

    public void activate(ApplicationId appId) {
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        if (!SecurityUtil.isAppSecured((ApplicationId)appId)) {
            return;
        }
        this.updateStoreAndWaitForNotificationHandling(appId, arg_0 -> ((ApplicationStore)this.store).activate(arg_0));
    }

    public void deactivate(ApplicationId appId) {
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        this.updateStoreAndWaitForNotificationHandling(appId, arg_0 -> ((ApplicationStore)this.store).deactivate(arg_0));
    }

    public void setPermissions(ApplicationId appId, Set<Permission> permissions) {
        Preconditions.checkNotNull((Object)appId, (Object)APP_ID_NULL);
        Preconditions.checkNotNull(permissions, (Object)"Permissions cannot be null");
        this.store.setPermissions(appId, permissions);
    }

    private void updateStoreAndWaitForNotificationHandling(ApplicationId appId, Consumer<ApplicationId> storeUpdateTask) {
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.pendingOperations.put((Object)appId, (Object)latch);
            storeUpdateTask.accept(appId);
        }
        catch (Exception e) {
            this.pendingOperations.invalidate((Object)appId);
            latch.countDown();
            this.log.warn("Failed to update store for {}", (Object)appId.name(), (Object)e);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private synchronized boolean installAppArtifacts(Application app) throws Exception {
        if (app.featuresRepo().isPresent() && this.featuresService.getRepository((URI)app.featuresRepo().get()) == null) {
            this.featuresService.addRepository((URI)app.featuresRepo().get());
            return true;
        }
        return false;
    }

    private synchronized boolean uninstallAppArtifacts(Application app) throws Exception {
        if (app.featuresRepo().isPresent() && this.featuresService.getRepository((URI)app.featuresRepo().get()) != null) {
            this.featuresService.removeRepository((URI)app.featuresRepo().get());
            return true;
        }
        return false;
    }

    private synchronized boolean installAppFeatures(Application app) throws Exception {
        boolean changed = false;
        for (String name : app.features()) {
            Feature feature = this.featuresService.getFeature(name);
            if (feature == null) {
                this.installAppArtifacts(app);
                feature = this.featuresService.getFeature(name);
            }
            if (feature != null && !this.featuresService.isInstalled(feature)) {
                this.featuresService.installFeature(name);
                changed = true;
                continue;
            }
            if (feature != null) continue;
            this.log.warn("Feature {} not found", (Object)name);
        }
        return changed;
    }

    private synchronized boolean uninstallAppFeatures(Application app) throws Exception {
        boolean changed = false;
        this.deactivateHooks.removeAll((Object)app.id().name()).forEach(hook -> this.invokeHook((Runnable)hook, app.id()));
        for (String name : app.features()) {
            Feature feature = this.featuresService.getFeature(name);
            if (feature != null && this.featuresService.isInstalled(feature)) {
                this.featuresService.uninstallFeature(name);
                changed = true;
                continue;
            }
            if (feature != null) continue;
            this.log.warn("Feature {} not found", (Object)name);
        }
        return changed;
    }

    private void invokeHook(Runnable hook, ApplicationId appId) {
        if (hook != null) {
            try {
                hook.run();
            }
            catch (Exception e) {
                this.log.warn("Deactivate hook for application {} encountered an error", (Object)appId.name(), (Object)e);
            }
        }
    }

    protected void bindStore(ApplicationStore applicationStore) {
        this.store = applicationStore;
    }

    protected void unbindStore(ApplicationStore applicationStore) {
        if (this.store == applicationStore) {
            this.store = null;
        }
    }

    protected void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected void unbindFeaturesService(FeaturesService featuresService) {
        if (this.featuresService == featuresService) {
            this.featuresService = null;
        }
    }

    private class InternalStoreDelegate
    implements ApplicationStoreDelegate {
        private InternalStoreDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(ApplicationEvent event) {
            ApplicationEvent.Type type = (ApplicationEvent.Type)event.type();
            Application app = (Application)event.subject();
            CountDownLatch latch = (CountDownLatch)ApplicationManager.this.pendingOperations.getIfPresent((Object)app.id());
            try {
                if (type == ApplicationEvent.Type.APP_ACTIVATED) {
                    if (ApplicationManager.this.installAppFeatures(app)) {
                        ApplicationManager.this.log.info("Application {} has been activated", (Object)app.id().name());
                    }
                } else if (type == ApplicationEvent.Type.APP_DEACTIVATED) {
                    if (ApplicationManager.this.uninstallAppFeatures(app)) {
                        ApplicationManager.this.log.info("Application {} has been deactivated", (Object)app.id().name());
                    }
                } else if (type == ApplicationEvent.Type.APP_INSTALLED) {
                    if (ApplicationManager.this.installAppArtifacts(app)) {
                        ApplicationManager.this.log.info("Application {} has been installed", (Object)app.id().name());
                    }
                } else if (type == ApplicationEvent.Type.APP_UNINSTALLED && (ApplicationManager.this.uninstallAppFeatures(app) || ApplicationManager.this.uninstallAppArtifacts(app))) {
                    ApplicationManager.this.log.info("Application {} has been uninstalled", (Object)app.id().name());
                }
                ApplicationManager.this.post((Event)event);
            }
            catch (Exception e) {
                ApplicationManager.this.log.warn("Unable to perform operation on application " + app.id().name(), (Throwable)e);
            }
            finally {
                if (latch != null) {
                    latch.countDown();
                    ApplicationManager.this.pendingOperations.invalidate((Object)app.id());
                }
            }
        }
    }
}

