/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.faultmanagement.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.onosproject.codec.CodecContext;
import org.onosproject.faultmanagement.web.AlarmCodec;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmService;
import org.onosproject.net.DeviceId;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="alarms")
public class AlarmsWebResource
extends AbstractWebResource {
    private static final String ALARM_NOT_FOUND = "Alarm is not found";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @GET
    @Produces(value={"application/json"})
    public Response getAlarms(@DefaultValue(value="false") @QueryParam(value="includeCleared") boolean includeCleared, @DefaultValue(value="") @QueryParam(value="devId") String devId) {
        this.log.debug("Requesting all alarms, includeCleared={}", (Object)includeCleared);
        AlarmService service = (AlarmService)this.get(AlarmService.class);
        Set alarms = StringUtils.isBlank((String)devId) ? (includeCleared ? service.getAlarms() : service.getActiveAlarms()) : service.getAlarms(DeviceId.deviceId((String)devId));
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("alarms", (JsonNode)new AlarmCodec().encode(alarms, (CodecContext)this));
        return AlarmsWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getAlarm(@PathParam(value="id") String id) {
        this.log.debug("HTTP GET alarm for id={}", (Object)id);
        AlarmId alarmId = AlarmId.alarmId((String)id);
        Alarm alarm = ((AlarmService)this.get(AlarmService.class)).getAlarm(alarmId);
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("alarm", (JsonNode)new AlarmCodec().encode(alarm, (CodecContext)this));
        return AlarmsWebResource.ok((Object)result.toString()).build();
    }

    @PUT
    @Path(value="{alarm_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="alarm_id") String alarmIdPath, InputStream stream) {
        this.log.debug("PUT NEW ALARM at /{}", (Object)alarmIdPath);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            this.log.debug("jsonTree={}", (Object)jsonTree);
            Alarm alarm = new AlarmCodec().decode(jsonTree, (CodecContext)this);
            AlarmService service = (AlarmService)this.get(AlarmService.class);
            if (!alarmIdPath.equals(alarm.id().toString())) {
                throw new IllegalArgumentException("id in path is " + alarmIdPath + " but payload uses id=" + alarm.id().toString());
            }
            Alarm updated = service.updateBookkeepingFields(alarm.id(), alarm.acknowledged(), alarm.assignedUser());
            ObjectNode encoded = new AlarmCodec().encode(updated, (CodecContext)this);
            return AlarmsWebResource.ok((Object)encoded.toString()).build();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }
}

