/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller.topology;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public class IsisRouterId {
    private static final String SCHEME = "l3";
    private static final long UNKNOWN = 0L;
    private final String ipAddress;

    public IsisRouterId(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public static IsisRouterId isisRouterId(String ipAddress) {
        return new IsisRouterId(ipAddress);
    }

    public static IsisRouterId isisRouterId(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new IsisRouterId(uri.getSchemeSpecificPart());
    }

    public static URI uri(IsisRouterId isisRouterId) {
        return IsisRouterId.uri(isisRouterId.ipAddress());
    }

    public static URI uri(String ipAddress) {
        try {
            return new URI(SCHEME, ipAddress, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String toString() {
        return this.ipAddress;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IsisRouterId)) {
            return false;
        }
        IsisRouterId otherIsisRouterId = (IsisRouterId)other;
        return Objects.equals(this.ipAddress, otherIsisRouterId.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress);
    }
}

