/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.isis.controller;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum IsisPduType {
    L1HELLOPDU(15),
    L2HELLOPDU(16),
    P2PHELLOPDU(17),
    L1LSPDU(18),
    L2LSPDU(20),
    L1CSNP(24),
    L2CSNP(25),
    L1PSNP(26),
    L2PSNP(27);

    private static final Map<Integer, IsisPduType> LOOKUP;
    private int value;

    private IsisPduType(int value) {
        this.value = value;
    }

    public static IsisPduType get(int pduTypeValue) {
        return LOOKUP.get(pduTypeValue);
    }

    public int value() {
        return this.value;
    }

    static {
        LOOKUP = new HashMap<Integer, IsisPduType>();
        for (IsisPduType isisPduType : EnumSet.allOf(IsisPduType.class)) {
            LOOKUP.put(isisPduType.value(), isisPduType);
        }
    }
}

