/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.instructions;

import java.util.Objects;
import org.onosproject.mapping.instructions.MappingInstruction;

public abstract class UnicastMappingInstruction
implements MappingInstruction {
    private static final String SEPARATOR = ":";

    public abstract UnicastType subtype();

    @Override
    public final MappingInstruction.Type type() {
        return MappingInstruction.Type.UNICAST;
    }

    public static final class PriorityMappingInstruction
    extends UnicastMappingInstruction {
        private final UnicastType subtype;
        private final int priority;

        PriorityMappingInstruction(UnicastType subType, int priority) {
            this.subtype = subType;
            this.priority = priority;
        }

        @Override
        public UnicastType subtype() {
            return this.subtype;
        }

        public int priority() {
            return this.priority;
        }

        public String toString() {
            return this.subtype().toString() + UnicastMappingInstruction.SEPARATOR + this.priority;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.priority});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PriorityMappingInstruction) {
                PriorityMappingInstruction that = (PriorityMappingInstruction)obj;
                return Objects.equals(this.priority, that.priority) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static final class WeightMappingInstruction
    extends UnicastMappingInstruction {
        private final UnicastType subtype;
        private final int weight;

        WeightMappingInstruction(UnicastType subType, int weight) {
            this.subtype = subType;
            this.weight = weight;
        }

        @Override
        public UnicastType subtype() {
            return this.subtype;
        }

        public int weight() {
            return this.weight;
        }

        public String toString() {
            return this.subtype().toString() + UnicastMappingInstruction.SEPARATOR + this.weight;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.weight});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof WeightMappingInstruction) {
                WeightMappingInstruction that = (WeightMappingInstruction)obj;
                return Objects.equals(this.weight, that.weight) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static enum UnicastType {
        WEIGHT,
        PRIORITY;

    }
}

