/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.instructions;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.onosproject.mapping.instructions.MulticastMappingInstruction;
import org.onosproject.mapping.instructions.UnicastMappingInstruction;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.instructions.ExtensionTreatment;

public final class MappingInstructions {
    private static final String SEPARATOR = ":";

    private MappingInstructions() {
    }

    public static UnicastMappingInstruction unicastWeight(int weight) {
        return new UnicastMappingInstruction.WeightMappingInstruction(UnicastMappingInstruction.UnicastType.WEIGHT, weight);
    }

    public static UnicastMappingInstruction unicastPriority(int priority) {
        return new UnicastMappingInstruction.PriorityMappingInstruction(UnicastMappingInstruction.UnicastType.PRIORITY, priority);
    }

    public static MulticastMappingInstruction multicastWeight(int weight) {
        return new MulticastMappingInstruction.WeightMappingInstruction(MulticastMappingInstruction.MulticastType.WEIGHT, weight);
    }

    public static MulticastMappingInstruction multicastPriority(int priority) {
        return new MulticastMappingInstruction.PriorityMappingInstruction(MulticastMappingInstruction.MulticastType.PRIORITY, priority);
    }

    public static ExtensionMappingInstructionWrapper extension(ExtensionTreatment extension, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)extension, (Object)"Extension instruction cannot be null");
        Preconditions.checkNotNull((Object)deviceId, (Object)"Device ID cannot be null");
        return new ExtensionMappingInstructionWrapper(extension, deviceId);
    }

    public static class ExtensionMappingInstructionWrapper
    implements MappingInstruction {
        private final ExtensionTreatment extensionTreatment;
        private final DeviceId deviceId;

        ExtensionMappingInstructionWrapper(ExtensionTreatment extension, DeviceId deviceId) {
            this.extensionTreatment = extension;
            this.deviceId = deviceId;
        }

        public ExtensionTreatment extensionMappingInstruction() {
            return this.extensionTreatment;
        }

        public DeviceId deviceId() {
            return this.deviceId;
        }

        @Override
        public MappingInstruction.Type type() {
            return MappingInstruction.Type.EXTENSION;
        }

        public String toString() {
            return this.type().toString() + MappingInstructions.SEPARATOR + this.deviceId + "/" + this.extensionTreatment;
        }

        public int hashCode() {
            return Objects.hash(this.type().ordinal(), this.extensionTreatment, this.deviceId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExtensionMappingInstructionWrapper) {
                ExtensionMappingInstructionWrapper that = (ExtensionMappingInstructionWrapper)obj;
                return Objects.equals(this.extensionTreatment, that.extensionTreatment) && Objects.equals(this.deviceId, that.deviceId);
            }
            return false;
        }
    }
}

