/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mapping.DefaultMappingValue;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.MappingValue;
import org.onosproject.mapping.actions.MappingAction;

public final class MappingValueCodec
extends JsonCodec<MappingValue> {
    protected static final String ACTION = "action";
    protected static final String TREATMENTS = "treatments";

    public ObjectNode encode(MappingValue value, CodecContext context) {
        Preconditions.checkNotNull((Object)value, (Object)"Mapping value cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        ArrayNode jsonTreatments = result.putArray(TREATMENTS);
        JsonCodec treatmentCodec = context.codec(MappingTreatment.class);
        JsonCodec actionCodec = context.codec(MappingAction.class);
        for (MappingTreatment treatment : value.treatments()) {
            jsonTreatments.add((JsonNode)treatmentCodec.encode((Object)treatment, context));
        }
        result.set(ACTION, (JsonNode)actionCodec.encode((Object)value.action(), context));
        return result;
    }

    public MappingValue decode(ObjectNode json, CodecContext context) {
        ObjectNode actionJson;
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec treatmentCodec = context.codec(MappingTreatment.class);
        JsonNode treatmentJson = json.get(TREATMENTS);
        MappingValue.Builder builder = DefaultMappingValue.builder();
        if (treatmentJson != null) {
            IntStream.range(0, treatmentJson.size()).forEach(i -> builder.add((MappingTreatment)treatmentCodec.decode(MappingValueCodec.get((JsonNode)treatmentJson, (int)i), context)));
        }
        if ((actionJson = MappingValueCodec.get((ObjectNode)json, (String)ACTION)) != null) {
            JsonCodec actionCodec = context.codec(MappingAction.class);
            builder.withAction((MappingAction)actionCodec.decode(actionJson, context));
        }
        return builder.build();
    }
}

