/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mapping.DefaultMappingTreatment;
import org.onosproject.mapping.MappingTreatment;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.instructions.MappingInstruction;

public final class MappingTreatmentCodec
extends JsonCodec<MappingTreatment> {
    private static final String INSTRUCTIONS = "instructions";
    private static final String ADDRESS = "address";

    public ObjectNode encode(MappingTreatment treatment, CodecContext context) {
        Preconditions.checkNotNull((Object)treatment, (Object)"Mapping treatment cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        ArrayNode jsonInstructions = result.putArray(INSTRUCTIONS);
        JsonCodec instructionCodec = context.codec(MappingInstruction.class);
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        for (MappingInstruction instruction : treatment.instructions()) {
            jsonInstructions.add((JsonNode)instructionCodec.encode((Object)instruction, context));
        }
        result.set(ADDRESS, (JsonNode)addressCodec.encode((Object)treatment.address(), context));
        return result;
    }

    public MappingTreatment decode(ObjectNode json, CodecContext context) {
        ObjectNode addressJson;
        if (json == null || !json.isObject()) {
            return null;
        }
        JsonCodec instructionCodec = context.codec(MappingInstruction.class);
        JsonNode instructionJson = json.get(INSTRUCTIONS);
        DefaultMappingTreatment.Builder builder = DefaultMappingTreatment.builder();
        if (instructionJson != null) {
            IntStream.range(0, instructionJson.size()).forEach(i -> builder.add((MappingInstruction)instructionCodec.decode(MappingTreatmentCodec.get((JsonNode)instructionJson, (int)i), context)));
        }
        if ((addressJson = MappingTreatmentCodec.get((ObjectNode)json, (String)ADDRESS)) != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            builder.withAddress((MappingAddress)addressCodec.decode(addressJson, context));
        }
        return builder.build();
    }
}

