/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mapping.DefaultMappingKey;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.addresses.MappingAddress;

public final class MappingKeyCodec
extends JsonCodec<MappingKey> {
    protected static final String ADDRESS = "address";

    public ObjectNode encode(MappingKey key, CodecContext context) {
        Preconditions.checkNotNull((Object)key, (Object)"Mapping key cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        JsonCodec addressCodec = context.codec(MappingAddress.class);
        result.set(ADDRESS, (JsonNode)addressCodec.encode((Object)key.address(), context));
        return result;
    }

    public MappingKey decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        MappingKey.Builder builder = DefaultMappingKey.builder();
        ObjectNode addressJson = MappingKeyCodec.get((ObjectNode)json, (String)ADDRESS);
        if (addressJson != null) {
            JsonCodec addressCodec = context.codec(MappingAddress.class);
            builder.withAddress((MappingAddress)addressCodec.decode(addressJson, context));
        }
        return builder.build();
    }
}

