/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mapping.codec.DecodeMappingInstructionCodecHelper;
import org.onosproject.mapping.codec.EncodeMappingInstructionCodecHelper;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingInstructionCodec
extends JsonCodec<MappingInstruction> {
    protected static final Logger log = LoggerFactory.getLogger(MappingInstructionCodec.class);
    protected static final String TYPE = "type";
    protected static final String SUBTYPE = "subtype";
    protected static final String UNICAST_WEIGHT = "unicastWeight";
    protected static final String UNICAST_PRIORITY = "unicastPriority";
    protected static final String MULTICAST_WEIGHT = "multicastWeight";
    protected static final String MULTICAST_PRIORITY = "multicastPriority";
    protected static final String MISSING_MEMBER_MESSAGE = " member is required in Instruction";
    protected static final String ERROR_MESSAGE = " not specified in Instruction";

    public ObjectNode encode(MappingInstruction instruction, CodecContext context) {
        Preconditions.checkNotNull((Object)instruction, (Object)"Mapping instruction cannot be null");
        return new EncodeMappingInstructionCodecHelper(instruction, context).encode();
    }

    public MappingInstruction decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        return new DecodeMappingInstructionCodecHelper(json, context).decode();
    }
}

