/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.mapping.MappingEntry;
import org.onosproject.mapping.MappingKey;
import org.onosproject.mapping.MappingValue;

public final class MappingEntryCodec
extends JsonCodec<MappingEntry> {
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected static final String ID = "id";
    protected static final String DEVICE_ID = "deviceId";
    protected static final String STATE = "state";

    public ObjectNode encode(MappingEntry mappingEntry, CodecContext context) {
        Preconditions.checkNotNull((Object)mappingEntry, (Object)"Mapping entry cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(ID, Long.toString(mappingEntry.id().value())).put(DEVICE_ID, mappingEntry.deviceId().toString()).put(STATE, mappingEntry.state().toString());
        if (mappingEntry.key() != null) {
            JsonCodec keyCodec = context.codec(MappingKey.class);
            result.set(KEY, (JsonNode)keyCodec.encode((Object)mappingEntry.key(), context));
        }
        if (mappingEntry.value() != null) {
            JsonCodec valueCodec = context.codec(MappingValue.class);
            result.set(VALUE, (JsonNode)valueCodec.encode((Object)mappingEntry.value(), context));
        }
        return result;
    }
}

