/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.codec.CodecContext;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.onosproject.mapping.instructions.MulticastMappingInstruction;
import org.onosproject.mapping.instructions.UnicastMappingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodeMappingInstructionCodecHelper {
    protected static final Logger log = LoggerFactory.getLogger(EncodeMappingInstructionCodecHelper.class);
    private final MappingInstruction instruction;
    private final CodecContext context;

    public EncodeMappingInstructionCodecHelper(MappingInstruction instruction, CodecContext context) {
        this.instruction = instruction;
        this.context = context;
    }

    private void encodeUnicast(ObjectNode result) {
        UnicastMappingInstruction unicastInstruction = (UnicastMappingInstruction)this.instruction;
        result.put("subtype", unicastInstruction.subtype().name());
        switch (unicastInstruction.subtype()) {
            case WEIGHT: {
                UnicastMappingInstruction.WeightMappingInstruction wmi = (UnicastMappingInstruction.WeightMappingInstruction)unicastInstruction;
                result.put("unicastWeight", wmi.weight());
                break;
            }
            case PRIORITY: {
                UnicastMappingInstruction.PriorityMappingInstruction pmi = (UnicastMappingInstruction.PriorityMappingInstruction)unicastInstruction;
                result.put("unicastPriority", pmi.priority());
                break;
            }
            default: {
                log.info("Cannot convert unicast subtype of {}", (Object)unicastInstruction.subtype());
            }
        }
    }

    private void encodeMulticast(ObjectNode result) {
        MulticastMappingInstruction multicastMappingInstruction = (MulticastMappingInstruction)this.instruction;
        result.put("subtype", multicastMappingInstruction.subtype().name());
        switch (multicastMappingInstruction.subtype()) {
            case WEIGHT: {
                MulticastMappingInstruction.WeightMappingInstruction wmi = (MulticastMappingInstruction.WeightMappingInstruction)multicastMappingInstruction;
                result.put("multicastWeight", wmi.weight());
                break;
            }
            case PRIORITY: {
                MulticastMappingInstruction.PriorityMappingInstruction pmi = (MulticastMappingInstruction.PriorityMappingInstruction)multicastMappingInstruction;
                result.put("multicastPriority", pmi.priority());
                break;
            }
            default: {
                log.info("Cannot convert multicast subtype of {}", (Object)multicastMappingInstruction.subtype());
            }
        }
    }

    public ObjectNode encode() {
        ObjectNode result = this.context.mapper().createObjectNode().put("type", this.instruction.type().toString());
        switch (this.instruction.type()) {
            case UNICAST: {
                this.encodeUnicast(result);
                break;
            }
            case MULTICAST: {
                this.encodeMulticast(result);
                break;
            }
            default: {
                log.info("Cannot convert mapping instruction type of {}", (Object)this.instruction.type());
            }
        }
        return result;
    }
}

