/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.EnumMap;
import org.onosproject.codec.CodecContext;
import org.onosproject.mapping.addresses.ASMappingAddress;
import org.onosproject.mapping.addresses.DNMappingAddress;
import org.onosproject.mapping.addresses.EthMappingAddress;
import org.onosproject.mapping.addresses.IPMappingAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class EncodeMappingAddressCodecHelper {
    private final MappingAddress address;
    private final CodecContext context;
    private final EnumMap<MappingAddress.Type, MappingAddressTypeFormatter> formatMap;

    public EncodeMappingAddressCodecHelper(MappingAddress address, CodecContext context) {
        this.address = address;
        this.context = context;
        this.formatMap = new EnumMap(MappingAddress.Type.class);
        this.formatMap.put(MappingAddress.Type.IPV4, new FormatIpv4());
        this.formatMap.put(MappingAddress.Type.IPV6, new FormatIpv6());
        this.formatMap.put(MappingAddress.Type.AS, new FormatAs());
        this.formatMap.put(MappingAddress.Type.DN, new FormatDn());
        this.formatMap.put(MappingAddress.Type.ETH, new FormatEth());
        this.formatMap.put(MappingAddress.Type.EXTENSION, new FormatUnknown());
    }

    public ObjectNode encode() {
        ObjectNode result = this.context.mapper().createObjectNode().put("type", this.address.type().toString());
        MappingAddressTypeFormatter formatter = (MappingAddressTypeFormatter)Preconditions.checkNotNull((Object)this.formatMap.get((Object)this.address.type()), (Object)("No formatter found for mapping address type " + this.address.type().toString()));
        return formatter.encodeMappingAddress(result, this.address);
    }

    private static class FormatUnknown
    implements MappingAddressTypeFormatter {
        private FormatUnknown() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            return root;
        }
    }

    private static class FormatExtension
    implements MappingAddressTypeFormatter {
        private FormatExtension() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            return null;
        }
    }

    private static class FormatEth
    implements MappingAddressTypeFormatter {
        private FormatEth() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            EthMappingAddress eth = (EthMappingAddress)address;
            return root.put("mac", eth.mac().toString());
        }
    }

    private static class FormatDn
    implements MappingAddressTypeFormatter {
        private FormatDn() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            DNMappingAddress dn = (DNMappingAddress)address;
            return root.put("dn", dn.name());
        }
    }

    private static class FormatAs
    implements MappingAddressTypeFormatter {
        private FormatAs() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            ASMappingAddress as = (ASMappingAddress)address;
            return root.put("as", as.asNumber());
        }
    }

    private static class FormatIpv6
    implements MappingAddressTypeFormatter {
        private FormatIpv6() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            IPMappingAddress ipv6 = (IPMappingAddress)address;
            return root.put("ipv6", ipv6.ip().toString());
        }
    }

    private static class FormatIpv4
    implements MappingAddressTypeFormatter {
        private FormatIpv4() {
        }

        @Override
        public ObjectNode encodeMappingAddress(ObjectNode root, MappingAddress address) {
            IPMappingAddress ipv4 = (IPMappingAddress)address;
            return root.put("ipv4", ipv4.ip().toString());
        }
    }

    private static interface MappingAddressTypeFormatter {
        public ObjectNode encodeMappingAddress(ObjectNode var1, MappingAddress var2);
    }
}

