/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.codec.CodecContext;
import org.onosproject.mapping.actions.DropMappingAction;
import org.onosproject.mapping.actions.ForwardMappingAction;
import org.onosproject.mapping.actions.MappingAction;
import org.onosproject.mapping.actions.NativeForwardMappingAction;
import org.onosproject.mapping.actions.NoMappingAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodeMappingActionCodecHelper {
    protected static final Logger log = LoggerFactory.getLogger(EncodeMappingActionCodecHelper.class);
    private final MappingAction action;
    private final CodecContext context;

    public EncodeMappingActionCodecHelper(MappingAction action, CodecContext context) {
        this.action = action;
        this.context = context;
    }

    private void encodeNoMappingAction(ObjectNode result) {
        NoMappingAction noMappingAction = (NoMappingAction)this.action;
        result.put("type", noMappingAction.type().name());
    }

    private void encodeDropMappingAction(ObjectNode result) {
        DropMappingAction dropMappingAction = (DropMappingAction)this.action;
        result.put("type", dropMappingAction.type().name());
    }

    private void encodeForwardMappingAction(ObjectNode result) {
        ForwardMappingAction forwardMappingAction = (ForwardMappingAction)this.action;
        result.put("type", forwardMappingAction.type().name());
    }

    private void encodeNativeForwardMappingAction(ObjectNode result) {
        NativeForwardMappingAction nativeMappingAction = (NativeForwardMappingAction)this.action;
        result.put("type", nativeMappingAction.type().name());
    }

    public ObjectNode encode() {
        ObjectNode result = this.context.mapper().createObjectNode().put("type", this.action.type().toString());
        switch (this.action.type()) {
            case DROP: {
                this.encodeDropMappingAction(result);
                break;
            }
            case FORWARD: {
                this.encodeForwardMappingAction(result);
                break;
            }
            case NATIVE_FORWARD: {
                this.encodeNativeForwardMappingAction(result);
                break;
            }
            case NO_ACTION: {
                this.encodeNoMappingAction(result);
                break;
            }
            default: {
                log.info("Cannot convert mapping action type of {}", (Object)this.action.type());
            }
        }
        return result;
    }
}

