/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.mapping.instructions.MappingInstruction;
import org.onosproject.mapping.instructions.MappingInstructions;
import org.onosproject.mapping.instructions.MulticastMappingInstruction;
import org.onosproject.mapping.instructions.UnicastMappingInstruction;

public final class DecodeMappingInstructionCodecHelper {
    private final ObjectNode json;
    private final CodecContext context;

    public DecodeMappingInstructionCodecHelper(ObjectNode json, CodecContext context) {
        this.json = json;
        this.context = context;
    }

    private MappingInstruction decodeUnicast() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(UnicastMappingInstruction.UnicastType.WEIGHT.name())) {
            int weight = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("unicastWeight"), (String)"unicastWeight member is required in Instruction")).asInt();
            return MappingInstructions.unicastWeight(weight);
        }
        if (subType.equals(UnicastMappingInstruction.UnicastType.PRIORITY.name())) {
            int priority = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("unicastPriority"), (String)"unicastPriority member is required in Instruction")).asInt();
            return MappingInstructions.unicastPriority(priority);
        }
        throw new IllegalArgumentException("Unicast MappingInstruction subtype " + subType + " is not supported");
    }

    private MappingInstruction decodeMulticast() {
        String subType = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("subtype"), (String)"subtype not specified in Instruction")).asText();
        if (subType.equals(MulticastMappingInstruction.MulticastType.WEIGHT.name())) {
            int weight = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("multicastWeight"), (String)"multicastWeight member is required in Instruction")).asInt();
            return MappingInstructions.multicastWeight(weight);
        }
        if (subType.equals(MulticastMappingInstruction.MulticastType.PRIORITY.name())) {
            int priority = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("multicastPriority"), (String)"multicastPriority member is required in Instruction")).asInt();
            return MappingInstructions.multicastPriority(priority);
        }
        throw new IllegalArgumentException("Multicast MappingInstruction subtype " + subType + " is not supported");
    }

    public MappingInstruction decode() {
        String type = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("type"), (String)"type not specified in Instruction")).asText();
        if (type.equals(MappingInstruction.Type.UNICAST.name())) {
            return this.decodeUnicast();
        }
        if (type.equals(MappingInstruction.Type.MULTICAST.name())) {
            return this.decodeMulticast();
        }
        throw new IllegalArgumentException("MappingInstruction type " + type + " is not supported");
    }
}

