/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.util.Map;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.mapping.addresses.MappingAddresses;

public final class DecodeMappingAddressCodecHelper {
    private final ObjectNode json;
    protected static final String MISSING_MEMBER_MESSAGE = " member is required in Mapping Address";
    private final Map<String, MappingAddressDecoder> decoderMap;

    public DecodeMappingAddressCodecHelper(ObjectNode json) {
        this.json = json;
        this.decoderMap = Maps.newHashMap();
        this.decoderMap.put(MappingAddress.Type.IPV4.name(), new Ipv4TypeDecoder());
        this.decoderMap.put(MappingAddress.Type.IPV6.name(), new Ipv6TypeDecoder());
        this.decoderMap.put(MappingAddress.Type.AS.name(), new AsTypeDecoder());
        this.decoderMap.put(MappingAddress.Type.DN.name(), new DnTypeDecoder());
        this.decoderMap.put(MappingAddress.Type.ETH.name(), new EthTypeDecoder());
    }

    public MappingAddress decode() {
        String type = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("type"), (String)"Type not specified")).asText();
        MappingAddressDecoder decoder = this.decoderMap.get(type);
        if (decoder != null) {
            return decoder.decodeMappingAddress(this.json);
        }
        throw new IllegalArgumentException("Type " + type + " is unknown");
    }

    private class EthTypeDecoder
    implements MappingAddressDecoder {
        private EthTypeDecoder() {
        }

        @Override
        public MappingAddress decodeMappingAddress(ObjectNode json) {
            MacAddress mac = MacAddress.valueOf((String)((JsonNode)Tools.nullIsIllegal((Object)json.get("mac"), (String)"mac member is required in Mapping Address")).asText());
            return MappingAddresses.ethMappingAddress(mac);
        }
    }

    private class DnTypeDecoder
    implements MappingAddressDecoder {
        private DnTypeDecoder() {
        }

        @Override
        public MappingAddress decodeMappingAddress(ObjectNode json) {
            String dn = ((JsonNode)Tools.nullIsIllegal((Object)json.get("dn"), (String)"dn member is required in Mapping Address")).asText();
            return MappingAddresses.dnMappingAddress(dn);
        }
    }

    private class AsTypeDecoder
    implements MappingAddressDecoder {
        private AsTypeDecoder() {
        }

        @Override
        public MappingAddress decodeMappingAddress(ObjectNode json) {
            String as = ((JsonNode)Tools.nullIsIllegal((Object)json.get("as"), (String)"as member is required in Mapping Address")).asText();
            return MappingAddresses.asMappingAddress(as);
        }
    }

    private class Ipv6TypeDecoder
    implements MappingAddressDecoder {
        private Ipv6TypeDecoder() {
        }

        @Override
        public MappingAddress decodeMappingAddress(ObjectNode json) {
            String ip = ((JsonNode)Tools.nullIsIllegal((Object)json.get("ipv6"), (String)"ipv6 member is required in Mapping Address")).asText();
            return MappingAddresses.ipv6MappingAddress(IpPrefix.valueOf((String)ip));
        }
    }

    private class Ipv4TypeDecoder
    implements MappingAddressDecoder {
        private Ipv4TypeDecoder() {
        }

        @Override
        public MappingAddress decodeMappingAddress(ObjectNode json) {
            String ip = ((JsonNode)Tools.nullIsIllegal((Object)json.get("ipv4"), (String)"ipv4 member is required in Mapping Address")).asText();
            return MappingAddresses.ipv4MappingAddress(IpPrefix.valueOf((String)ip));
        }
    }

    private static interface MappingAddressDecoder {
        public MappingAddress decodeMappingAddress(ObjectNode var1);
    }
}

