/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onlab.util.Tools;
import org.onosproject.mapping.actions.MappingAction;
import org.onosproject.mapping.actions.MappingActions;

public final class DecodeMappingActionCodecHelper {
    private final ObjectNode json;

    public DecodeMappingActionCodecHelper(ObjectNode json) {
        this.json = json;
    }

    private MappingAction decodeNoAction() {
        return MappingActions.noAction();
    }

    private MappingAction decodeForwardAction() {
        return MappingActions.forward();
    }

    private MappingAction decodeNativeForwardAction() {
        return MappingActions.nativeForward();
    }

    private MappingAction decodeDropAction() {
        return MappingActions.drop();
    }

    public MappingAction decode() {
        String type = ((JsonNode)Tools.nullIsIllegal((Object)this.json.get("type"), (String)"type not specified in MappingAction")).asText();
        if (type.equals(MappingAction.Type.DROP.name())) {
            return this.decodeDropAction();
        }
        if (type.equals(MappingAction.Type.FORWARD.name())) {
            return this.decodeForwardAction();
        }
        if (type.equals(MappingAction.Type.NATIVE_FORWARD.name())) {
            return this.decodeNativeForwardAction();
        }
        if (type.equals(MappingAction.Type.NO_ACTION.name())) {
            return this.decodeNoAction();
        }
        throw new IllegalArgumentException("MappingAction type " + type + " is not supported");
    }
}

