/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.addresses;

import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.mapping.addresses.ASMappingAddress;
import org.onosproject.mapping.addresses.DNMappingAddress;
import org.onosproject.mapping.addresses.EthMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddress;
import org.onosproject.mapping.addresses.ExtensionMappingAddressWrapper;
import org.onosproject.mapping.addresses.IPMappingAddress;
import org.onosproject.mapping.addresses.MappingAddress;
import org.onosproject.net.DeviceId;

public final class MappingAddresses {
    private MappingAddresses() {
    }

    public static ASMappingAddress asMappingAddress(String asn) {
        return new ASMappingAddress(asn);
    }

    public static DNMappingAddress dnMappingAddress(String dn) {
        return new DNMappingAddress(dn);
    }

    public static EthMappingAddress ethMappingAddress(MacAddress mac) {
        return new EthMappingAddress(mac);
    }

    public static IPMappingAddress ipv4MappingAddress(IpPrefix ip) {
        return new IPMappingAddress(ip, MappingAddress.Type.IPV4);
    }

    public static IPMappingAddress ipv6MappingAddress(IpPrefix ip) {
        return new IPMappingAddress(ip, MappingAddress.Type.IPV6);
    }

    public static ExtensionMappingAddressWrapper extensionMappingAddressWrapper(ExtensionMappingAddress address, DeviceId deviceId) {
        return new ExtensionMappingAddressWrapper(address, deviceId);
    }

    public static ExtensionMappingAddressWrapper extensionMappingAddressWrapper(ExtensionMappingAddress address) {
        return new ExtensionMappingAddressWrapper(address, null);
    }
}

