/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.addresses;

import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.onosproject.mapping.addresses.MappingAddress;

public final class IPMappingAddress
implements MappingAddress {
    private final IpPrefix ip;
    private final MappingAddress.Type type;

    IPMappingAddress(IpPrefix ip, MappingAddress.Type type) {
        this.ip = ip;
        this.type = type;
    }

    @Override
    public MappingAddress.Type type() {
        return this.type;
    }

    public IpPrefix ip() {
        return this.ip;
    }

    public String toString() {
        return this.type().toString() + ":" + this.ip;
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.ip);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPMappingAddress) {
            IPMappingAddress that = (IPMappingAddress)obj;
            return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }
}

