/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mapping.addresses;

import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.mapping.addresses.MappingAddress;

public final class EthMappingAddress
implements MappingAddress {
    private final MacAddress mac;

    EthMappingAddress(MacAddress mac) {
        this.mac = mac;
    }

    @Override
    public MappingAddress.Type type() {
        return MappingAddress.Type.ETH;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public String toString() {
        return this.type().toString() + ":" + this.mac;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{MappingAddress.Type.ETH, this.mac});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EthMappingAddress) {
            EthMappingAddress that = (EthMappingAddress)obj;
            return Objects.equals(this.mac, that.mac);
        }
        return false;
    }
}

